/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.iotdb.session.pool;

import java.time.ZoneId;
import java.util.Collections;
import java.util.List;
import shaded.org.apache.iotdb.isession.pool.ITableSessionPool;
import shaded.org.apache.iotdb.session.pool.AbstractSessionPoolBuilder;
import shaded.org.apache.iotdb.session.pool.SessionPool;
import shaded.org.apache.iotdb.session.pool.TableSessionPool;

public class TableSessionPoolBuilder
extends AbstractSessionPoolBuilder {
    public TableSessionPoolBuilder nodeUrls(List<String> nodeUrls) {
        this.nodeUrls = nodeUrls;
        return this;
    }

    public TableSessionPoolBuilder maxSize(int maxSize) {
        this.maxSize = maxSize;
        return this;
    }

    public TableSessionPoolBuilder user(String user) {
        this.username = user;
        return this;
    }

    public TableSessionPoolBuilder password(String password) {
        this.pw = password;
        return this;
    }

    public TableSessionPoolBuilder database(String database) {
        this.database = database;
        return this;
    }

    public TableSessionPoolBuilder queryTimeoutInMs(long queryTimeoutInMs) {
        this.timeOut = queryTimeoutInMs;
        return this;
    }

    public TableSessionPoolBuilder fetchSize(int fetchSize) {
        this.fetchSize = fetchSize;
        return this;
    }

    public TableSessionPoolBuilder zoneId(ZoneId zoneId) {
        this.zoneId = zoneId;
        return this;
    }

    public TableSessionPoolBuilder waitToGetSessionTimeoutInMs(long waitToGetSessionTimeoutInMs) {
        this.waitToGetSessionTimeoutInMs = waitToGetSessionTimeoutInMs;
        return this;
    }

    public TableSessionPoolBuilder thriftDefaultBufferSize(int thriftDefaultBufferSize) {
        this.thriftDefaultBufferSize = thriftDefaultBufferSize;
        return this;
    }

    public TableSessionPoolBuilder thriftMaxFrameSize(int thriftMaxFrameSize) {
        this.thriftMaxFrameSize = thriftMaxFrameSize;
        return this;
    }

    public TableSessionPoolBuilder enableIoTDBRpcCompression(boolean enableCompression) {
        this.isIoTDBRpcCompressionEnabled = enableCompression;
        return this;
    }

    public TableSessionPoolBuilder enableThriftCompression(boolean enableCompression) {
        this.isThriftRpcCompactionEnabled = enableCompression;
        return this;
    }

    public TableSessionPoolBuilder enableRedirection(boolean enableRedirection) {
        this.enableRedirection = enableRedirection;
        return this;
    }

    public TableSessionPoolBuilder connectionTimeoutInMs(int connectionTimeoutInMs) {
        this.connectionTimeoutInMs = connectionTimeoutInMs;
        return this;
    }

    public TableSessionPoolBuilder enableAutoFetch(boolean enableAutoFetch) {
        this.enableAutoFetch = enableAutoFetch;
        return this;
    }

    public TableSessionPoolBuilder maxRetryCount(int maxRetryCount) {
        this.maxRetryCount = maxRetryCount;
        return this;
    }

    public TableSessionPoolBuilder retryIntervalInMs(long retryIntervalInMs) {
        this.retryIntervalInMs = retryIntervalInMs;
        return this;
    }

    public TableSessionPoolBuilder useSSL(boolean useSSL) {
        this.useSSL = useSSL;
        return this;
    }

    public TableSessionPoolBuilder trustStore(String keyStore) {
        this.trustStore = keyStore;
        return this;
    }

    public TableSessionPoolBuilder trustStorePwd(String keyStorePwd) {
        this.trustStorePwd = keyStorePwd;
        return this;
    }

    public ITableSessionPool build() {
        if (this.nodeUrls == null) {
            this.nodeUrls = Collections.singletonList("localhost:6667");
        }
        this.sqlDialect = "table";
        SessionPool sessionPool = new SessionPool(this);
        return new TableSessionPool(sessionPool);
    }
}

