/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.iotdb.session.rpccompress;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.time.LocalDate;
import java.util.List;
import shaded.org.apache.iotdb.session.util.SessionUtils;
import shaded.org.apache.tsfile.compress.ICompressor;
import shaded.org.apache.tsfile.encoding.encoder.Encoder;
import shaded.org.apache.tsfile.encoding.encoder.TSEncodingBuilder;
import shaded.org.apache.tsfile.enums.TSDataType;
import shaded.org.apache.tsfile.file.metadata.enums.CompressionType;
import shaded.org.apache.tsfile.file.metadata.enums.TSEncoding;
import shaded.org.apache.tsfile.utils.Binary;
import shaded.org.apache.tsfile.utils.BitMap;
import shaded.org.apache.tsfile.utils.BytesUtils;
import shaded.org.apache.tsfile.utils.DateUtils;
import shaded.org.apache.tsfile.utils.PublicBAOS;
import shaded.org.apache.tsfile.utils.ReadWriteIOUtils;
import shaded.org.apache.tsfile.write.record.Tablet;
import shaded.org.apache.tsfile.write.schema.IMeasurementSchema;

public class TabletEncoder {
    private final CompressionType compressionType;
    private final List<TSEncoding> encodingList;

    public TabletEncoder(CompressionType compressionType, List<TSEncoding> encodingList) {
        this.compressionType = compressionType;
        this.encodingList = encodingList;
    }

    public ByteBuffer encodeTime(Tablet tablet) {
        Encoder encoder = TSEncodingBuilder.getEncodingBuilder(this.encodingList.get(0)).getEncoder(TSDataType.INT64);
        PublicBAOS baos = new PublicBAOS();
        for (int i = 0; i < tablet.getRowSize(); ++i) {
            encoder.encode(tablet.getTimestamp(i), (ByteArrayOutputStream)baos);
        }
        try {
            encoder.flush(baos);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        ByteBuffer buffer = ByteBuffer.wrap(baos.getBuf(), 0, baos.size());
        return this.compressBuffer(buffer);
    }

    public ByteBuffer encodeValues(Tablet tablet) {
        PublicBAOS baos = new PublicBAOS();
        List<IMeasurementSchema> schemas = tablet.getSchemas();
        int schemasSize = schemas.size();
        for (int j = 0; j < schemasSize; ++j) {
            IMeasurementSchema schema = schemas.get(j);
            TSDataType dataType = schema.getType();
            TSEncoding encoding = this.encodingList.get(j + 1);
            Encoder encoder = TSEncodingBuilder.getEncodingBuilder(encoding).getEncoder(dataType);
            if (encoding == TSEncoding.PLAIN) {
                if (dataType.isBinary()) {
                    this.encodePlainBinary(tablet, j, baos);
                    continue;
                }
                if (dataType == TSDataType.INT32) {
                    this.encodePlainI32(tablet, j, baos);
                    continue;
                }
                if (dataType == TSDataType.DATE) {
                    this.encodePlainDate(tablet, j, baos);
                    continue;
                }
                SessionUtils.encodeValue(dataType, tablet, j, encoder, baos);
                continue;
            }
            SessionUtils.encodeValue(dataType, tablet, j, encoder, baos);
        }
        this.encodeBitMap(tablet, baos);
        ByteBuffer buffer = ByteBuffer.wrap(baos.getBuf(), 0, baos.size());
        return this.compressBuffer(buffer);
    }

    private void encodePlainBinary(Tablet tablet, int j, ByteArrayOutputStream baos) {
        Binary[] binaryValues = (Binary[])tablet.getValues()[j];
        try {
            for (int index = 0; index < tablet.getRowSize(); ++index) {
                if (!tablet.isNull(index, j)) {
                    ReadWriteIOUtils.write(binaryValues[index], (OutputStream)baos);
                    continue;
                }
                ReadWriteIOUtils.write(Binary.EMPTY_VALUE, (OutputStream)baos);
            }
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    private void encodePlainI32(Tablet tablet, int j, ByteArrayOutputStream baos) {
        int[] intValues = (int[])tablet.getValues()[j];
        try {
            for (int index = 0; index < tablet.getRowSize(); ++index) {
                ReadWriteIOUtils.write(intValues[index], (OutputStream)baos);
            }
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    private void encodePlainDate(Tablet tablet, int j, ByteArrayOutputStream baos) {
        LocalDate[] dateValues = (LocalDate[])tablet.getValues()[j];
        try {
            for (int index = 0; index < tablet.getRowSize(); ++index) {
                if (!tablet.isNull(index, j)) {
                    ReadWriteIOUtils.write((int)DateUtils.parseDateExpressionToInt(dateValues[index]), (OutputStream)baos);
                    continue;
                }
                ReadWriteIOUtils.write(0, (OutputStream)baos);
            }
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    private void encodeBitMap(Tablet tablet, ByteArrayOutputStream baos) {
        BitMap[] bitMaps = tablet.getBitMaps();
        if (bitMaps != null) {
            try (DataOutputStream dataOutputStream = new DataOutputStream(baos);){
                for (BitMap bitMap : bitMaps) {
                    boolean columnHasNull = bitMap != null && !bitMap.isAllUnmarked(tablet.getRowSize());
                    dataOutputStream.writeByte(BytesUtils.boolToByte(columnHasNull));
                    if (!columnHasNull) continue;
                    dataOutputStream.write(bitMap.getTruncatedByteArray(tablet.getRowSize()));
                }
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    private ByteBuffer compressBuffer(ByteBuffer buffer) {
        if (this.compressionType != CompressionType.UNCOMPRESSED) {
            ICompressor compressor = ICompressor.getCompressor(this.compressionType);
            int uncompressedSize = buffer.remaining();
            byte[] compressed = new byte[compressor.getMaxBytesForCompression(uncompressedSize) + 4];
            try {
                int compressedLength = compressor.compress(buffer.array(), buffer.arrayOffset() + buffer.position(), uncompressedSize, compressed);
                buffer = ByteBuffer.wrap(compressed, 0, compressedLength + 4);
                buffer.position(compressedLength);
                buffer.putInt(uncompressedSize);
                buffer.rewind();
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
        return buffer;
    }
}

