/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.iotdb.session.subscription;

import java.time.ZoneId;
import java.util.Objects;
import shaded.org.apache.iotdb.common.rpc.thrift.TEndPoint;
import shaded.org.apache.iotdb.rpc.IoTDBConnectionException;
import shaded.org.apache.iotdb.rpc.subscription.exception.SubscriptionParameterNotValidException;
import shaded.org.apache.iotdb.session.AbstractSessionBuilder;
import shaded.org.apache.iotdb.session.Session;
import shaded.org.apache.iotdb.session.SessionConnection;
import shaded.org.apache.iotdb.session.subscription.SubscriptionSessionConnection;

public final class SubscriptionSessionWrapper
extends Session {
    public SubscriptionSessionWrapper(AbstractSessionBuilder builder) {
        super(builder);
    }

    @Override
    public void open() throws IoTDBConnectionException {
        super.open();
    }

    @Override
    public void close() throws IoTDBConnectionException {
        super.close();
    }

    @Override
    public SessionConnection constructSessionConnection(Session session, TEndPoint endpoint, ZoneId zoneId) throws IoTDBConnectionException {
        if (Objects.isNull(endpoint)) {
            throw new SubscriptionParameterNotValidException("Subscription session must be configured with an endpoint.");
        }
        return new SubscriptionSessionConnection(session, endpoint, zoneId, this.availableNodes, this.maxRetryCount, this.retryIntervalInMs, this.sqlDialect, this.database);
    }

    public SubscriptionSessionConnection getSessionConnection() throws IoTDBConnectionException {
        return (SubscriptionSessionConnection)this.getDefaultSessionConnection();
    }

    public int getThriftMaxFrameSize() {
        return this.thriftMaxFrameSize;
    }
}

