/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.iotdb.session.subscription.consumer.base;

import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.SortedMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import shaded.org.apache.iotdb.rpc.subscription.exception.SubscriptionException;
import shaded.org.apache.iotdb.session.subscription.consumer.AsyncCommitCallback;
import shaded.org.apache.iotdb.session.subscription.consumer.base.AbstractSubscriptionConsumer;
import shaded.org.apache.iotdb.session.subscription.consumer.base.AbstractSubscriptionPullConsumerBuilder;
import shaded.org.apache.iotdb.session.subscription.consumer.base.SubscriptionExecutorServiceManager;
import shaded.org.apache.iotdb.session.subscription.payload.SubscriptionMessage;
import shaded.org.apache.iotdb.session.subscription.util.CollectionUtils;
import shaded.org.apache.iotdb.session.subscription.util.IdentifierUtils;

public abstract class AbstractSubscriptionPullConsumer
extends AbstractSubscriptionConsumer {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractSubscriptionPullConsumer.class);
    private final boolean autoCommit;
    private final long autoCommitIntervalMs;
    private SortedMap<Long, Set<SubscriptionMessage>> uncommittedMessages;
    private final AtomicBoolean isClosed = new AtomicBoolean(true);

    @Override
    boolean isClosed() {
        return this.isClosed.get();
    }

    protected AbstractSubscriptionPullConsumer(AbstractSubscriptionPullConsumerBuilder builder) {
        super(builder);
        this.autoCommit = builder.autoCommit;
        this.autoCommitIntervalMs = builder.autoCommitIntervalMs;
    }

    public AbstractSubscriptionPullConsumer(Properties properties) {
        this(properties, (Boolean)properties.getOrDefault((Object)"auto-commit", (Object)true), (Long)properties.getOrDefault((Object)"auto-commit-interval-ms", (Object)5000L));
    }

    protected AbstractSubscriptionPullConsumer(Properties properties, boolean autoCommit, long autoCommitIntervalMs) {
        super(new AbstractSubscriptionPullConsumerBuilder().autoCommit(autoCommit).autoCommitIntervalMs(autoCommitIntervalMs), properties);
        this.autoCommit = autoCommit;
        this.autoCommitIntervalMs = Math.max(autoCommitIntervalMs, 500L);
    }

    @Override
    protected synchronized void open() throws SubscriptionException {
        if (!this.isClosed.get()) {
            return;
        }
        super.open();
        this.isClosed.set(false);
        if (this.autoCommit) {
            this.uncommittedMessages = new ConcurrentSkipListMap<Long, Set<SubscriptionMessage>>();
            this.submitAutoCommitWorker();
        }
    }

    @Override
    public synchronized void close() {
        if (this.isClosed.get()) {
            return;
        }
        if (this.autoCommit) {
            this.commitAllUncommittedMessages();
        }
        super.close();
        this.isClosed.set(true);
    }

    protected List<SubscriptionMessage> poll(Duration timeout) throws SubscriptionException {
        return this.poll(Collections.emptySet(), timeout.toMillis());
    }

    protected List<SubscriptionMessage> poll(long timeoutMs) throws SubscriptionException {
        return this.poll(Collections.emptySet(), timeoutMs);
    }

    protected List<SubscriptionMessage> poll(Set<String> topicNames, Duration timeout) throws SubscriptionException {
        return this.poll(topicNames, timeout.toMillis());
    }

    protected List<SubscriptionMessage> poll(Set<String> topicNames, long timeoutMs) throws SubscriptionException {
        Set<Object> parsedTopicNames = topicNames.stream().map(IdentifierUtils::checkAndParseIdentifier).collect(Collectors.toSet());
        if (!parsedTopicNames.isEmpty()) {
            parsedTopicNames.stream().filter(topicName -> !this.subscribedTopics.containsKey(topicName)).forEach(topicName -> LOGGER.warn("SubscriptionPullConsumer {} does not subscribe to topic {}", (Object)this, topicName));
        } else {
            parsedTopicNames = this.subscribedTopics.keySet();
        }
        if (parsedTopicNames.isEmpty()) {
            return Collections.emptyList();
        }
        List<SubscriptionMessage> messages = this.multiplePoll(parsedTopicNames, timeoutMs);
        if (messages.isEmpty()) {
            LOGGER.info("SubscriptionPullConsumer {} poll empty message from topics {} after {} millisecond(s)", this, CollectionUtils.getLimitedString(parsedTopicNames, 32), timeoutMs);
            return messages;
        }
        if (this.autoCommit) {
            long currentTimestamp = System.currentTimeMillis();
            long index = currentTimestamp / this.autoCommitIntervalMs;
            if (currentTimestamp % this.autoCommitIntervalMs == 0L) {
                --index;
            }
            this.uncommittedMessages.computeIfAbsent(index, o -> new ConcurrentSkipListSet()).addAll(messages);
        }
        return messages;
    }

    protected void commitSync(SubscriptionMessage message) throws SubscriptionException {
        super.ack(Collections.singletonList(message));
    }

    protected void commitSync(Iterable<SubscriptionMessage> messages) throws SubscriptionException {
        super.ack(messages);
    }

    protected CompletableFuture<Void> commitAsync(SubscriptionMessage message) {
        return super.commitAsync(Collections.singletonList(message));
    }

    @Override
    protected CompletableFuture<Void> commitAsync(Iterable<SubscriptionMessage> messages) {
        return super.commitAsync(messages);
    }

    protected void commitAsync(SubscriptionMessage message, AsyncCommitCallback callback) {
        super.commitAsync(Collections.singletonList(message), callback);
    }

    @Override
    protected void commitAsync(Iterable<SubscriptionMessage> messages, AsyncCommitCallback callback) {
        super.commitAsync(messages, callback);
    }

    private void submitAutoCommitWorker() {
        ScheduledFuture[] future;
        future = new ScheduledFuture[]{SubscriptionExecutorServiceManager.submitAutoCommitWorker(() -> {
            if (this.isClosed()) {
                if (Objects.nonNull(future[0])) {
                    future[0].cancel(false);
                    LOGGER.info("SubscriptionPullConsumer {} cancel auto commit worker", (Object)this);
                }
                return;
            }
            new AutoCommitWorker().run();
        }, this.autoCommitIntervalMs)};
        LOGGER.info("SubscriptionPullConsumer {} submit auto commit worker", (Object)this);
    }

    private void commitAllUncommittedMessages() {
        for (Map.Entry<Long, Set<SubscriptionMessage>> entry : this.uncommittedMessages.entrySet()) {
            try {
                this.ack((Iterable<SubscriptionMessage>)entry.getValue());
                this.uncommittedMessages.remove(entry.getKey());
            }
            catch (Exception e) {
                LOGGER.warn("something unexpected happened when commit messages during close", e);
            }
        }
    }

    public String toString() {
        return "SubscriptionPullConsumer" + this.coreReportMessage();
    }

    @Override
    protected Map<String, String> coreReportMessage() {
        Map<String, String> coreReportMessage = super.coreReportMessage();
        coreReportMessage.put("autoCommit", String.valueOf(this.autoCommit));
        return coreReportMessage;
    }

    @Override
    protected Map<String, String> allReportMessage() {
        Map<String, String> allReportMessage = super.allReportMessage();
        allReportMessage.put("autoCommit", String.valueOf(this.autoCommit));
        allReportMessage.put("autoCommitIntervalMs", String.valueOf(this.autoCommitIntervalMs));
        if (this.autoCommit) {
            allReportMessage.put("uncommittedMessages", this.uncommittedMessages.toString());
        }
        return allReportMessage;
    }

    private class AutoCommitWorker
    implements Runnable {
        private AutoCommitWorker() {
        }

        @Override
        public void run() {
            if (AbstractSubscriptionPullConsumer.this.isClosed()) {
                return;
            }
            long currentTimestamp = System.currentTimeMillis();
            long index = currentTimestamp / AbstractSubscriptionPullConsumer.this.autoCommitIntervalMs;
            if (currentTimestamp % AbstractSubscriptionPullConsumer.this.autoCommitIntervalMs == 0L) {
                --index;
            }
            for (Map.Entry entry : AbstractSubscriptionPullConsumer.this.uncommittedMessages.headMap(index).entrySet()) {
                try {
                    AbstractSubscriptionPullConsumer.this.ack((Iterable)entry.getValue());
                    AbstractSubscriptionPullConsumer.this.uncommittedMessages.remove(entry.getKey());
                }
                catch (Exception e) {
                    LOGGER.warn("something unexpected happened when auto commit messages...", e);
                }
            }
        }
    }
}

