/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.iotdb.session.subscription.consumer.tree;

import java.util.List;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import shaded.org.apache.iotdb.common.rpc.thrift.TEndPoint;
import shaded.org.apache.iotdb.rpc.subscription.config.ConsumerConstant;
import shaded.org.apache.iotdb.rpc.subscription.exception.SubscriptionException;
import shaded.org.apache.iotdb.session.subscription.consumer.AckStrategy;
import shaded.org.apache.iotdb.session.subscription.consumer.ConsumeListener;
import shaded.org.apache.iotdb.session.subscription.consumer.ConsumeResult;
import shaded.org.apache.iotdb.session.subscription.consumer.ISubscriptionTreePushConsumer;
import shaded.org.apache.iotdb.session.subscription.consumer.base.AbstractSubscriptionProvider;
import shaded.org.apache.iotdb.session.subscription.consumer.base.AbstractSubscriptionPushConsumer;
import shaded.org.apache.iotdb.session.subscription.consumer.tree.SubscriptionTreeProvider;
import shaded.org.apache.iotdb.session.subscription.consumer.tree.SubscriptionTreePushConsumerBuilder;
import shaded.org.apache.iotdb.session.subscription.util.IdentifierUtils;
import shaded.org.apache.thrift.annotation.Nullable;

public class SubscriptionTreePushConsumer
extends AbstractSubscriptionPushConsumer
implements ISubscriptionTreePushConsumer {
    @Override
    protected AbstractSubscriptionProvider constructSubscriptionProvider(TEndPoint endPoint, String username, String password, String consumerId, String consumerGroupId, int thriftMaxFrameSize) {
        return new SubscriptionTreeProvider(endPoint, username, password, consumerId, consumerGroupId, thriftMaxFrameSize);
    }

    public SubscriptionTreePushConsumer(SubscriptionTreePushConsumerBuilder builder) {
        super(builder);
    }

    @Deprecated
    private SubscriptionTreePushConsumer(Builder builder) {
        super(((SubscriptionTreePushConsumerBuilder)new SubscriptionTreePushConsumerBuilder().host(builder.host).port(builder.port).nodeUrls(builder.nodeUrls)).username(builder.username).password(builder.password).consumerId(builder.consumerId).consumerGroupId(builder.consumerGroupId).heartbeatIntervalMs(builder.heartbeatIntervalMs).endpointsSyncIntervalMs(builder.endpointsSyncIntervalMs).fileSaveDir(builder.fileSaveDir).fileSaveFsync(builder.fileSaveFsync).thriftMaxFrameSize(builder.thriftMaxFrameSize).maxPollParallelism(builder.maxPollParallelism).ackStrategy(builder.ackStrategy).consumeListener(builder.consumeListener).autoPollIntervalMs(builder.autoPollIntervalMs).autoPollTimeoutMs(builder.autoPollTimeoutMs));
    }

    public SubscriptionTreePushConsumer(Properties config) {
        this(config, (AckStrategy)((Object)config.getOrDefault((Object)"ack-strategy", (Object)AckStrategy.defaultValue())), (ConsumeListener)config.getOrDefault((Object)"consume-listener", message -> ConsumeResult.SUCCESS), (Long)config.getOrDefault((Object)"auto-poll-interval-ms", (Object)100L), (Long)config.getOrDefault((Object)"auto-poll-timeout-ms", (Object)10000L));
    }

    private SubscriptionTreePushConsumer(Properties config, AckStrategy ackStrategy, ConsumeListener consumeListener, long autoPollIntervalMs, long autoPollTimeoutMs) {
        super(config, ackStrategy, consumeListener, autoPollIntervalMs, autoPollTimeoutMs);
    }

    @Override
    public void open() throws SubscriptionException {
        super.open();
    }

    @Override
    public void close() throws SubscriptionException {
        super.close();
    }

    @Override
    public void subscribe(String topicName) throws SubscriptionException {
        super.subscribe(topicName);
    }

    @Override
    public void subscribe(String ... topicNames) throws SubscriptionException {
        super.subscribe(topicNames);
    }

    @Override
    public void subscribe(Set<String> topicNames) throws SubscriptionException {
        super.subscribe(topicNames);
    }

    @Override
    public void unsubscribe(String topicName) throws SubscriptionException {
        super.unsubscribe(topicName);
    }

    @Override
    public void unsubscribe(String ... topicNames) throws SubscriptionException {
        super.unsubscribe(topicNames);
    }

    @Override
    public void unsubscribe(Set<String> topicNames) throws SubscriptionException {
        super.unsubscribe(topicNames);
    }

    @Override
    public String getConsumerId() {
        return super.getConsumerId();
    }

    @Override
    public String getConsumerGroupId() {
        return super.getConsumerGroupId();
    }

    @Deprecated
    public static class Builder {
        private String host;
        private Integer port;
        private List<String> nodeUrls;
        private String username = "root";
        private String password = "TimechoDB@2021";
        private String consumerId;
        private String consumerGroupId;
        private long heartbeatIntervalMs = 30000L;
        private long endpointsSyncIntervalMs = 120000L;
        private String fileSaveDir = ConsumerConstant.FILE_SAVE_DIR_DEFAULT_VALUE;
        private boolean fileSaveFsync = false;
        private int thriftMaxFrameSize = 0x4000000;
        private int maxPollParallelism = 1;
        private AckStrategy ackStrategy = AckStrategy.defaultValue();
        private ConsumeListener consumeListener = message -> ConsumeResult.SUCCESS;
        private long autoPollIntervalMs = 100L;
        private long autoPollTimeoutMs = 10000L;

        public Builder host(String host) {
            this.host = host;
            return this;
        }

        public Builder port(Integer port) {
            this.port = port;
            return this;
        }

        public Builder nodeUrls(List<String> nodeUrls) {
            this.nodeUrls = nodeUrls;
            return this;
        }

        public Builder username(String username) {
            this.username = username;
            return this;
        }

        public Builder password(String password) {
            this.password = password;
            return this;
        }

        public Builder consumerId(@Nullable String consumerId) {
            if (Objects.isNull(consumerId)) {
                return this;
            }
            this.consumerId = IdentifierUtils.checkAndParseIdentifier(consumerId);
            return this;
        }

        public Builder consumerGroupId(@Nullable String consumerGroupId) {
            if (Objects.isNull(consumerGroupId)) {
                return this;
            }
            this.consumerGroupId = IdentifierUtils.checkAndParseIdentifier(consumerGroupId);
            return this;
        }

        public Builder heartbeatIntervalMs(long heartbeatIntervalMs) {
            this.heartbeatIntervalMs = Math.max(heartbeatIntervalMs, 1000L);
            return this;
        }

        public Builder endpointsSyncIntervalMs(long endpointsSyncIntervalMs) {
            this.endpointsSyncIntervalMs = Math.max(endpointsSyncIntervalMs, 5000L);
            return this;
        }

        public Builder fileSaveDir(String fileSaveDir) {
            this.fileSaveDir = fileSaveDir;
            return this;
        }

        public Builder fileSaveFsync(boolean fileSaveFsync) {
            this.fileSaveFsync = fileSaveFsync;
            return this;
        }

        public Builder thriftMaxFrameSize(int thriftMaxFrameSize) {
            this.thriftMaxFrameSize = thriftMaxFrameSize;
            return this;
        }

        public Builder maxPollParallelism(int maxPollParallelism) {
            this.maxPollParallelism = Math.max(maxPollParallelism, 1);
            return this;
        }

        public Builder ackStrategy(AckStrategy ackStrategy) {
            this.ackStrategy = ackStrategy;
            return this;
        }

        public Builder consumeListener(ConsumeListener consumeListener) {
            this.consumeListener = consumeListener;
            return this;
        }

        public Builder autoPollIntervalMs(long autoPollIntervalMs) {
            this.autoPollIntervalMs = Math.max(autoPollIntervalMs, 1L);
            return this;
        }

        public Builder autoPollTimeoutMs(long autoPollTimeoutMs) {
            this.autoPollTimeoutMs = Math.max(autoPollTimeoutMs, 1000L);
            return this;
        }

        public SubscriptionTreePushConsumer buildPushConsumer() {
            return new SubscriptionTreePushConsumer(this);
        }
    }
}

