/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.iotdb.session.subscription.payload;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import shaded.org.apache.iotdb.session.subscription.payload.SubscriptionMessageHandler;
import shaded.org.apache.iotdb.session.util.RetryUtils;

public abstract class SubscriptionFileHandler
implements SubscriptionMessageHandler {
    protected final String absolutePath;

    public SubscriptionFileHandler(String absolutePath) {
        this.absolutePath = absolutePath;
    }

    public synchronized File getFile() {
        return new File(this.absolutePath);
    }

    public synchronized Path getPath() {
        return Paths.get(this.absolutePath, new String[0]);
    }

    public synchronized Path deleteFile() throws IOException {
        Path sourcePath = this.getPath();
        return RetryUtils.retryOnException(() -> {
            Files.delete(sourcePath);
            return sourcePath;
        });
    }

    public synchronized Path moveFile(String target) throws IOException {
        return RetryUtils.retryOnException(() -> this.moveFile(Paths.get(target, new String[0])));
    }

    public synchronized Path moveFile(Path target) throws IOException {
        if (!Files.exists(target.getParent(), new LinkOption[0])) {
            Files.createDirectories(target.getParent(), new FileAttribute[0]);
        }
        return RetryUtils.retryOnException(() -> Files.move(this.getPath(), target, StandardCopyOption.REPLACE_EXISTING));
    }

    public synchronized Path copyFile(String target) throws IOException {
        return RetryUtils.retryOnException(() -> this.copyFile(Paths.get(target, new String[0])));
    }

    public synchronized Path copyFile(Path target) throws IOException {
        if (!Files.exists(target.getParent(), new LinkOption[0])) {
            Files.createDirectories(target.getParent(), new FileAttribute[0]);
        }
        return RetryUtils.retryOnException(() -> Files.copy(this.getPath(), target, StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.COPY_ATTRIBUTES));
    }
}

