/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.iotdb.session.subscription.util;

import java.util.Objects;
import shaded.org.apache.iotdb.rpc.subscription.exception.SubscriptionIdentifierSemanticException;
import shaded.org.apache.tsfile.common.constant.TsFileConstant;
import shaded.org.apache.tsfile.read.common.parser.PathVisitor;

public class IdentifierUtils {
    public static String checkAndParseIdentifier(String src) {
        if (Objects.isNull(src)) {
            throw new SubscriptionIdentifierSemanticException("null identifier is not supported");
        }
        if (src.isEmpty()) {
            throw new SubscriptionIdentifierSemanticException("empty identifier is not supported");
        }
        if (src.startsWith("`") && src.endsWith("`")) {
            return src.substring(1, src.length() - 1).replace("``", "`");
        }
        IdentifierUtils.checkIdentifier(src);
        return src;
    }

    private static void checkIdentifier(String src) {
        if (!TsFileConstant.IDENTIFIER_PATTERN.matcher(src).matches() || PathVisitor.isRealNumber(src)) {
            throw new SubscriptionIdentifierSemanticException(String.format("%s is illegal, identifier not enclosed with backticks can only consist of digits, characters and underscore.", src));
        }
    }
}

