/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.iotdb.session.util;

public class RetryUtils {
    public static final int MAX_RETRIES = 3;

    public static <T, E extends Exception> T retryOnException(CallableWithException<T, E> callable) throws E {
        int attempt = 0;
        while (true) {
            try {
                return callable.call();
            }
            catch (Exception e) {
                if (++attempt < 3) continue;
                throw e;
            }
            break;
        }
    }

    private RetryUtils() {
    }

    public static interface CallableWithException<T, E extends Exception> {
        public T call() throws E;
    }
}

