/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.thrift.transport;

import java.lang.ref.WeakReference;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import javax.security.auth.callback.CallbackHandler;
import javax.security.sasl.Sasl;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import shaded.org.apache.thrift.transport.TSaslTransport;
import shaded.org.apache.thrift.transport.TTransport;
import shaded.org.apache.thrift.transport.TTransportException;
import shaded.org.apache.thrift.transport.TTransportFactory;
import shaded.org.apache.thrift.transport.sasl.NegotiationStatus;
import shaded.org.apache.thrift.transport.sasl.TSaslServerDefinition;

public class TSaslServerTransport
extends TSaslTransport {
    private static final Logger LOGGER = LoggerFactory.getLogger(TSaslServerTransport.class);
    private Map<String, TSaslServerDefinition> serverDefinitionMap = new HashMap<String, TSaslServerDefinition>();

    public TSaslServerTransport(TTransport transport) throws TTransportException {
        super(transport);
    }

    public TSaslServerTransport(String mechanism, String protocol, String serverName, Map<String, String> props, CallbackHandler cbh, TTransport transport) throws TTransportException {
        super(transport);
        this.addServerDefinition(mechanism, protocol, serverName, props, cbh);
    }

    private TSaslServerTransport(Map<String, TSaslServerDefinition> serverDefinitionMap, TTransport transport) throws TTransportException {
        super(transport);
        this.serverDefinitionMap.putAll(serverDefinitionMap);
    }

    public void addServerDefinition(String mechanism, String protocol, String serverName, Map<String, String> props, CallbackHandler cbh) {
        this.serverDefinitionMap.put(mechanism, new TSaslServerDefinition(mechanism, protocol, serverName, props, cbh));
    }

    @Override
    protected TSaslTransport.SaslRole getRole() {
        return TSaslTransport.SaslRole.SERVER;
    }

    @Override
    protected void handleSaslStartMessage() throws TTransportException, SaslException {
        TSaslTransport.SaslResponse message = this.receiveSaslMessage();
        LOGGER.debug("Received start message with status {}", (Object)message.status);
        if (message.status != NegotiationStatus.START) {
            throw this.sendAndThrowMessage(NegotiationStatus.ERROR, "Expecting START status, received " + (Object)((Object)message.status));
        }
        String mechanismName = new String(message.payload, StandardCharsets.UTF_8);
        TSaslServerDefinition serverDefinition = this.serverDefinitionMap.get(mechanismName);
        LOGGER.debug("Received mechanism name '{}'", (Object)mechanismName);
        if (serverDefinition == null) {
            throw this.sendAndThrowMessage(NegotiationStatus.BAD, "Unsupported mechanism type " + mechanismName);
        }
        SaslServer saslServer = Sasl.createSaslServer(serverDefinition.mechanism, serverDefinition.protocol, serverDefinition.serverName, serverDefinition.props, serverDefinition.cbh);
        this.setSaslServer(saslServer);
    }

    public static class Factory
    extends TTransportFactory {
        private static Map<TTransport, WeakReference<TSaslServerTransport>> transportMap = Collections.synchronizedMap(new WeakHashMap());
        private Map<String, TSaslServerDefinition> serverDefinitionMap = new HashMap<String, TSaslServerDefinition>();

        public Factory() {
        }

        public Factory(String mechanism, String protocol, String serverName, Map<String, String> props, CallbackHandler cbh) {
            this.addServerDefinition(mechanism, protocol, serverName, props, cbh);
        }

        public void addServerDefinition(String mechanism, String protocol, String serverName, Map<String, String> props, CallbackHandler cbh) {
            this.serverDefinitionMap.put(mechanism, new TSaslServerDefinition(mechanism, protocol, serverName, props, cbh));
        }

        @Override
        public TTransport getTransport(TTransport base) throws TTransportException {
            WeakReference<TSaslServerTransport> ret = transportMap.get(base);
            if (ret == null || ret.get() == null) {
                LOGGER.debug("transport map does not contain key", (Object)base);
                ret = new WeakReference<TSaslServerTransport>(new TSaslServerTransport(this.serverDefinitionMap, base));
                try {
                    ((TSaslServerTransport)ret.get()).open();
                }
                catch (TTransportException e) {
                    LOGGER.debug("failed to open server transport", e);
                    throw new RuntimeException(e);
                }
                transportMap.put(base, ret);
            } else {
                LOGGER.debug("transport map does contain key {}", (Object)base);
            }
            return (TTransport)ret.get();
        }
    }
}

