/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.tsfile.common.bitStream;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import shaded.org.apache.tsfile.common.bitStream.BitStream;

public class BitInputStream
extends BitStream {
    protected InputStream in;
    protected int buffer;
    protected int bufferBitCount;
    protected final long totalBits;
    protected long bitsRead = 0L;
    protected int markedBuffer = 0;
    protected int markedBufferBitCount = 0;
    protected long markedBitsRead = 0L;

    public BitInputStream(InputStream in, long totalBits) {
        this.in = in;
        this.totalBits = totalBits;
        this.bufferBitCount = 0;
    }

    public int readInt(int numBits) throws IOException {
        if (this.availableBits() <= 0) {
            throw new EOFException();
        }
        this.bitsRead += (long)numBits;
        int result = 0;
        boolean hasReadData = false;
        while (numBits > 0) {
            if (this.bufferBitCount == 0) {
                this.buffer = this.in.read();
                if (this.buffer < 0) {
                    if (!hasReadData) {
                        throw new EOFException();
                    }
                    return result;
                }
                this.bufferBitCount = 8;
            }
            if (this.bufferBitCount > numBits) {
                result = this.buffer >> this.bufferBitCount - numBits & MASKS[numBits] | result;
                this.bufferBitCount -= numBits;
                numBits = 0;
            } else {
                result = (this.buffer & MASKS[this.bufferBitCount]) << numBits - this.bufferBitCount | result;
                numBits -= this.bufferBitCount;
                this.bufferBitCount = 0;
            }
            hasReadData = true;
        }
        return result;
    }

    public long readLong(int numBits) throws IOException {
        if (this.availableBits() <= 0) {
            throw new EOFException();
        }
        this.bitsRead += (long)numBits;
        if (numBits > 64 || numBits < 0) {
            throw new IllegalArgumentException("numBits must be between 0 and 64");
        }
        long result = 0L;
        boolean hasReadData = false;
        while (numBits > 0) {
            if (this.bufferBitCount == 0) {
                this.buffer = this.in.read();
                if (this.buffer < 0) {
                    if (!hasReadData) {
                        throw new EOFException();
                    }
                    return result;
                }
                this.bufferBitCount = 8;
            }
            if (this.bufferBitCount > numBits) {
                int shift = this.bufferBitCount - numBits;
                result = result << numBits | (long)(this.buffer >> shift & MASKS[numBits]);
                this.bufferBitCount -= numBits;
                this.buffer &= MASKS[this.bufferBitCount];
                numBits = 0;
            } else {
                result = result << this.bufferBitCount | (long)(this.buffer & MASKS[this.bufferBitCount]);
                numBits -= this.bufferBitCount;
                this.bufferBitCount = 0;
            }
            hasReadData = true;
        }
        return result;
    }

    public static int readVarInt(BitInputStream in) throws IOException {
        int result;
        block1: {
            result = 0;
            int shift = 0;
            do {
                int chunk = in.readInt(7);
                boolean hasNext = in.readBit();
                result |= chunk << shift;
                if (!hasNext) break block1;
            } while ((shift += 7) < 32);
            throw new IOException("VarInt too long");
        }
        return result >>> 1 ^ -(result & 1);
    }

    public static long readVarLong(BitInputStream in) throws IOException {
        long result;
        block1: {
            result = 0L;
            int shift = 0;
            do {
                long chunk = in.readInt(7);
                boolean hasNext = in.readBit();
                result |= chunk << shift;
                shift += 7;
                if (!hasNext) break block1;
            } while (shift < 64);
            throw new IOException("VarLong too long: overflow");
        }
        return result >>> 1 ^ -(result & 1L);
    }

    public boolean readBit() throws IOException {
        if (this.availableBits() <= 0) {
            throw new EOFException();
        }
        ++this.bitsRead;
        if (this.bufferBitCount == 0) {
            this.buffer = this.in.read();
            if (this.buffer < 0) {
                throw new EOFException();
            }
            this.bufferBitCount = 8;
        }
        boolean bit = (this.buffer >> this.bufferBitCount - 1 & 1) != 0;
        --this.bufferBitCount;
        return bit;
    }

    public boolean markSupported() {
        return this.in.markSupported();
    }

    public void mark(int readLimit) {
        this.in.mark((readLimit + 8 - 1) / 8);
        this.markedBuffer = this.buffer;
        this.markedBufferBitCount = this.bufferBitCount;
        this.markedBitsRead = this.bitsRead;
    }

    public void reset() throws IOException {
        this.in.reset();
        this.buffer = this.markedBuffer;
        this.bufferBitCount = this.markedBufferBitCount;
        this.bitsRead = this.markedBitsRead;
    }

    public int availableBits() throws IOException {
        return (int)Math.min((long)this.in.available() * 8L + (long)this.bufferBitCount, this.totalBits - this.bitsRead);
    }

    public void close() throws IOException {
        this.in.close();
    }
}

