/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.tsfile.common.bitStream;

import java.io.IOException;
import java.io.OutputStream;
import shaded.org.apache.tsfile.common.bitStream.BitStream;

public class BitOutputStream
extends BitStream {
    protected OutputStream out;
    protected int buffer;
    protected int bufferBitCount;
    protected int bitsWritten;

    public BitOutputStream(OutputStream out) {
        this.out = out;
        this.buffer = 0;
        this.bufferBitCount = 0;
        this.bitsWritten = 0;
    }

    public void reset(OutputStream out) {
        this.out = out;
        this.buffer = 0;
        this.bufferBitCount = 0;
        this.bitsWritten = 0;
    }

    public void writeInt(int data, int numBits) throws IOException {
        this.bitsWritten += numBits;
        while (numBits > 0) {
            int rest = 8 - this.bufferBitCount;
            if (rest > numBits) {
                this.buffer |= (data & MASKS[numBits]) << rest - numBits;
                this.bufferBitCount += numBits;
                numBits = 0;
                continue;
            }
            this.buffer |= data >> numBits - rest & MASKS[rest];
            this.out.write(this.buffer);
            this.buffer = 0;
            this.bufferBitCount = 0;
            numBits -= rest;
        }
    }

    public void writeLong(long data, int numBits) throws IOException {
        if (numBits > 64 || numBits < 0) {
            throw new IllegalArgumentException("numBits must be between 0 and 64");
        }
        this.bitsWritten += numBits;
        while (numBits > 0) {
            int toWrite;
            int shift;
            int rest = 8 - this.bufferBitCount;
            if (rest > numBits) {
                shift = rest - numBits;
                toWrite = (int)((data & (long)MASKS[numBits]) << shift);
                this.buffer |= toWrite;
                this.bufferBitCount += numBits;
                numBits = 0;
                continue;
            }
            shift = numBits - rest;
            toWrite = (int)(data >> shift & (long)MASKS[rest]);
            this.buffer |= toWrite;
            this.out.write(this.buffer);
            this.buffer = 0;
            this.bufferBitCount = 0;
            numBits -= rest;
        }
    }

    public static int writeVarInt(int value, BitOutputStream out) throws IOException {
        int uValue = value << 1 ^ value >> 31;
        int bits = 0;
        while ((uValue & 0xFFFFFF80) != 0) {
            out.writeInt(uValue & 0x7F, 7);
            out.writeBit(true);
            uValue >>>= 7;
            bits += 8;
        }
        out.writeInt(uValue, 7);
        out.writeBit(false);
        return bits += 8;
    }

    public static int writeVarLong(long value, BitOutputStream out) throws IOException {
        long uValue = value << 1 ^ value >> 63;
        int bitsWritten = 0;
        while ((uValue & 0xFFFFFFFFFFFFFF80L) != 0L) {
            int chunk = (int)(uValue & 0x7FL);
            out.writeInt(chunk, 7);
            out.writeBit(true);
            uValue >>>= 7;
            bitsWritten += 8;
        }
        out.writeInt((int)(uValue & 0x7FL), 7);
        out.writeBit(false);
        return bitsWritten += 8;
    }

    public void writeBit(boolean bit) throws IOException {
        ++this.bitsWritten;
        this.buffer |= (bit ? 1 : 0) << 7 - this.bufferBitCount;
        ++this.bufferBitCount;
        if (this.bufferBitCount == 8) {
            this.out.write(this.buffer);
            this.buffer = 0;
            this.bufferBitCount = 0;
        }
    }

    public void close() throws IOException {
        if (this.bufferBitCount > 0) {
            this.out.write(this.buffer);
        }
        this.out.close();
    }

    public int getBitsWritten() {
        return this.bitsWritten;
    }
}

