/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.tsfile.common.conf;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Paths;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import shaded.org.apache.tsfile.common.conf.TSFileConfig;
import shaded.org.apache.tsfile.utils.Loader;

public class TSFileDescriptor {
    private static final Logger logger = LoggerFactory.getLogger(TSFileDescriptor.class);
    private final TSFileConfig conf = new TSFileConfig();

    TSFileDescriptor() {
        this.init();
    }

    public static TSFileDescriptor getInstance() {
        return TsfileDescriptorHolder.INSTANCE;
    }

    public TSFileConfig getConfig() {
        return this.conf;
    }

    private void init() {
        this.loadProperties().ifPresent(this::overwriteConfigByCustomSettings);
    }

    public void overwriteConfigByCustomSettings(Properties properties) {
        PropertiesOverWriter writer = new PropertiesOverWriter(properties);
        writer.setInt(this.conf::setGroupSizeInByte, "group_size_in_byte");
        writer.setInt(this.conf::setPageSizeInByte, "page_size_in_byte");
        if (this.conf.getPageSizeInByte() > this.conf.getGroupSizeInByte()) {
            int groupSizeInByte = this.conf.getGroupSizeInByte();
            logger.warn("page_size is greater than group size, will set it as the same with group size {}", (Object)groupSizeInByte);
            this.conf.setPageSizeInByte(groupSizeInByte);
        }
        writer.setInt(this.conf::setMaxNumberOfPointsInPage, "max_number_of_points_in_page");
        writer.setInt(this.conf::setMaxDegreeOfIndexNode, "max_degree_of_index_node");
        writer.setInt(this.conf::setMaxStringLength, "max_string_length");
        writer.setInt(this.conf::setFloatPrecision, "float_precision");
        writer.setString(this.conf::setValueEncoder, "value_encoder");
        writer.setString(this.conf::setCompressor, "compressor");
        writer.setString(this.conf::setBooleanCompression, "boolean_compressor");
        writer.setString(this.conf::setInt32Compression, "int32_compressor");
        writer.setString(this.conf::setInt64Compression, "int64_compressor");
        writer.setString(this.conf::setFloatCompression, "float_compressor");
        writer.setString(this.conf::setDoubleCompression, "double_compressor");
        writer.setString(this.conf::setTextCompression, "text_compressor");
        writer.setInt(this.conf::setBatchSize, "batch_size");
        writer.setString(this.conf::setEncryptType, "encrypt_type");
        writer.setBoolean(this.conf::setLz4UseJni, "lz4_use_jni");
        this.conf.setEncryptKeyFromToken(System.getenv("user_encrypt_token"));
    }

    private Optional<Properties> loadProperties() {
        String file = this.detectPropertiesFile();
        if (file != null) {
            logger.info("try loading {} from {}", (Object)"iotdb-system.properties", (Object)file);
            return this.loadPropertiesFromFile(file);
        }
        logger.warn("not found {}, use the default configs.", (Object)"iotdb-system.properties");
        return Optional.empty();
    }

    private Optional<Properties> loadPropertiesFromFile(String filePath) {
        Optional<Properties> optional;
        FileInputStream fileInputStream = new FileInputStream(filePath);
        try {
            Properties properties = new Properties();
            properties.load(new InputStreamReader((InputStream)fileInputStream, StandardCharsets.UTF_8));
            optional = Optional.of(properties);
        }
        catch (Throwable throwable) {
            try {
                try {
                    fileInputStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (FileNotFoundException e) {
                logger.warn("Fail to find config file {}", (Object)filePath);
                return Optional.empty();
            }
            catch (IOException e) {
                logger.warn("read file ({}) failure, please check the access permissions.", (Object)filePath);
                return Optional.empty();
            }
        }
        fileInputStream.close();
        return optional;
    }

    private String detectPropertiesFile() {
        String confDirectory = System.getProperty("TSFILE_CONF");
        if (confDirectory != null) {
            return Paths.get(confDirectory, "iotdb-system.properties").toAbsolutePath().toString();
        }
        String tsFileHome = System.getProperty("TSFILE_HOME");
        if (tsFileHome != null) {
            return Paths.get(tsFileHome, "conf", "iotdb-system.properties").toAbsolutePath().toString();
        }
        return this.detectPropertiesFromClassPath();
    }

    private static URL getResource(String filename, ClassLoader classLoader) {
        return Loader.getResource(filename, classLoader);
    }

    private String detectPropertiesFromClassPath() {
        ClassLoader classLoader = Loader.getClassLoaderOfObject(this);
        URL u = TSFileDescriptor.getResource("iotdb-system.properties", classLoader);
        if (u == null) {
            return null;
        }
        this.multiplicityWarning("iotdb-system.properties", classLoader);
        return u.getFile();
    }

    private void multiplicityWarning(String resource, ClassLoader classLoader) {
        try {
            Set<URI> uriSet = Loader.getResources(resource, classLoader);
            if (uriSet.size() > 1) {
                logger.warn("Resource [{}] occurs multiple times on the classpath", (Object)resource);
                for (URI uri : uriSet) {
                    logger.warn("Resource [{}] occurs at [{}]", (Object)resource, (Object)uri);
                }
            }
        }
        catch (IOException | URISyntaxException e) {
            logger.error("Failed to get url list for {}", (Object)resource);
        }
    }

    private static class TsfileDescriptorHolder {
        private static final TSFileDescriptor INSTANCE = new TSFileDescriptor();

        private TsfileDescriptorHolder() {
            throw new IllegalAccessError("Utility class");
        }
    }

    private static class PropertiesOverWriter {
        private final Properties properties;

        public PropertiesOverWriter(Properties properties) {
            if (properties == null) {
                throw new NullPointerException("properties should not be null");
            }
            this.properties = properties;
        }

        public void setInt(Consumer<Integer> setter, String propertyKey) {
            this.set(setter, propertyKey, Integer::parseInt);
        }

        public void setDouble(Consumer<Double> setter, String propertyKey) {
            this.set(setter, propertyKey, Double::parseDouble);
        }

        public void setString(Consumer<String> setter, String propertyKey) {
            this.set(setter, propertyKey, Function.identity());
        }

        public void setBoolean(Consumer<Boolean> setter, String propertyKey) {
            this.set(setter, propertyKey, Boolean::parseBoolean);
        }

        private <T> void set(Consumer<T> setter, String propertyKey, Function<String, T> propertyValueConverter) {
            String value = this.properties.getProperty(propertyKey);
            if (value != null) {
                try {
                    T v = propertyValueConverter.apply(value);
                    setter.accept(v);
                }
                catch (Exception e) {
                    logger.warn("invalid value for {}, use the default value", (Object)propertyKey);
                }
            }
        }
    }
}

