/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.tsfile.compatibility;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import shaded.org.apache.tsfile.compatibility.BufferDeserializer;
import shaded.org.apache.tsfile.compatibility.StreamDeserializer;
import shaded.org.apache.tsfile.file.IMetadataIndexEntry;
import shaded.org.apache.tsfile.file.metadata.DeviceMetadataIndexEntry;
import shaded.org.apache.tsfile.file.metadata.IDeviceID;
import shaded.org.apache.tsfile.file.metadata.MeasurementMetadataIndexEntry;
import shaded.org.apache.tsfile.file.metadata.MetadataIndexNode;
import shaded.org.apache.tsfile.file.metadata.StringArrayDeviceID;
import shaded.org.apache.tsfile.file.metadata.TableSchema;
import shaded.org.apache.tsfile.file.metadata.TsFileMetadata;
import shaded.org.apache.tsfile.write.schema.MeasurementSchema;

public class DeserializeConfig {
    public byte versionNumber = (byte)4;
    public BufferDeserializer<TsFileMetadata> tsFileMetadataBufferDeserializer = TsFileMetadata::deserializeWithoutCacheTableSchemaMap;
    public BufferDeserializer<TsFileMetadata> cacheTableSchemaMapTsFileMetadataBufferDeserializer = TsFileMetadata::deserializeAndCacheTableSchemaMap;
    public BufferDeserializer<MetadataIndexNode> deviceMetadataIndexNodeBufferDeserializer = (buffer, context) -> MetadataIndexNode.deserializeFrom(buffer, true, context);
    public BufferDeserializer<MetadataIndexNode> measurementMetadataIndexNodeBufferDeserializer = (buffer, context) -> MetadataIndexNode.deserializeFrom(buffer, false, context);
    public BufferDeserializer<IMetadataIndexEntry> deviceMetadataIndexEntryBufferDeserializer = DeviceMetadataIndexEntry::deserializeFrom;
    public BufferDeserializer<IMetadataIndexEntry> measurementMetadataIndexEntryBufferDeserializer = (buffer, context) -> MeasurementMetadataIndexEntry.deserializeFrom(buffer);
    public BufferDeserializer<TableSchema> tableSchemaBufferDeserializer = TableSchema::deserialize;
    public BufferDeserializer<MeasurementSchema> measurementSchemaBufferDeserializer = (buffer, context) -> MeasurementSchema.deserializeFrom(buffer);
    public BufferDeserializer<IDeviceID> deviceIDBufferDeserializer = (buffer, context) -> StringArrayDeviceID.deserialize(buffer);
    public StreamDeserializer<MetadataIndexNode> deviceMetadataIndexNodeStreamDeserializer = (stream, context) -> MetadataIndexNode.deserializeFrom(stream, true, context);
    public StreamDeserializer<MetadataIndexNode> measurementMetadataIndexNodeStreamDeserializer = (stream, context) -> MetadataIndexNode.deserializeFrom(stream, false, context);
    public StreamDeserializer<IMetadataIndexEntry> deviceMetadataIndexEntryStreamDeserializer = DeviceMetadataIndexEntry::deserializeFrom;
    public StreamDeserializer<IMetadataIndexEntry> measurementMetadataIndexEntryStreamDeserializer = (stream, context) -> MeasurementMetadataIndexEntry.deserializeFrom(stream);
    public StreamDeserializer<IDeviceID> deviceIDStreamDeserializer = (stream, context) -> StringArrayDeviceID.deserialize(stream);

    public MetadataIndexNode deserializeMetadataIndexNode(ByteBuffer buffer, boolean isDeviceLevel) {
        if (isDeviceLevel) {
            return this.deviceMetadataIndexNodeBufferDeserializer.deserialize(buffer, this);
        }
        return this.measurementMetadataIndexNodeBufferDeserializer.deserialize(buffer, this);
    }

    public IMetadataIndexEntry deserializeMetadataIndexEntry(ByteBuffer buffer, boolean isDeviceLevel) {
        if (isDeviceLevel) {
            return this.deviceMetadataIndexEntryBufferDeserializer.deserialize(buffer, this);
        }
        return this.measurementMetadataIndexEntryBufferDeserializer.deserialize(buffer, this);
    }

    public MetadataIndexNode deserializeMetadataIndexNode(InputStream stream, boolean isDeviceLevel) throws IOException {
        if (isDeviceLevel) {
            return this.deviceMetadataIndexNodeStreamDeserializer.deserialize(stream, this);
        }
        return this.measurementMetadataIndexNodeStreamDeserializer.deserialize(stream, this);
    }

    public IMetadataIndexEntry deserializeMetadataIndexEntry(InputStream stream, boolean isDeviceLevel) throws IOException {
        if (isDeviceLevel) {
            return this.deviceMetadataIndexEntryStreamDeserializer.deserialize(stream, this);
        }
        return this.measurementMetadataIndexEntryStreamDeserializer.deserialize(stream, this);
    }
}

