/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.tsfile.encoding.decoder;

import java.io.IOException;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import shaded.org.apache.tsfile.encoding.decoder.CamelDecoder;
import shaded.org.apache.tsfile.encoding.decoder.DeltaBinaryDecoder;
import shaded.org.apache.tsfile.encoding.decoder.DictionaryDecoder;
import shaded.org.apache.tsfile.encoding.decoder.DoublePrecisionChimpDecoder;
import shaded.org.apache.tsfile.encoding.decoder.DoublePrecisionDecoderV1;
import shaded.org.apache.tsfile.encoding.decoder.DoublePrecisionDecoderV2;
import shaded.org.apache.tsfile.encoding.decoder.DoubleRLBEDecoder;
import shaded.org.apache.tsfile.encoding.decoder.DoubleSprintzDecoder;
import shaded.org.apache.tsfile.encoding.decoder.FloatDecoder;
import shaded.org.apache.tsfile.encoding.decoder.FloatRLBEDecoder;
import shaded.org.apache.tsfile.encoding.decoder.FloatSprintzDecoder;
import shaded.org.apache.tsfile.encoding.decoder.IntChimpDecoder;
import shaded.org.apache.tsfile.encoding.decoder.IntGorillaDecoder;
import shaded.org.apache.tsfile.encoding.decoder.IntRLBEDecoder;
import shaded.org.apache.tsfile.encoding.decoder.IntRleDecoder;
import shaded.org.apache.tsfile.encoding.decoder.IntSprintzDecoder;
import shaded.org.apache.tsfile.encoding.decoder.IntZigzagDecoder;
import shaded.org.apache.tsfile.encoding.decoder.LongChimpDecoder;
import shaded.org.apache.tsfile.encoding.decoder.LongGorillaDecoder;
import shaded.org.apache.tsfile.encoding.decoder.LongRLBEDecoder;
import shaded.org.apache.tsfile.encoding.decoder.LongRleDecoder;
import shaded.org.apache.tsfile.encoding.decoder.LongSprintzDecoder;
import shaded.org.apache.tsfile.encoding.decoder.LongZigzagDecoder;
import shaded.org.apache.tsfile.encoding.decoder.PlainDecoder;
import shaded.org.apache.tsfile.encoding.decoder.RegularDataDecoder;
import shaded.org.apache.tsfile.encoding.decoder.SinglePrecisionChimpDecoder;
import shaded.org.apache.tsfile.encoding.decoder.SinglePrecisionDecoderV1;
import shaded.org.apache.tsfile.encoding.decoder.SinglePrecisionDecoderV2;
import shaded.org.apache.tsfile.enums.TSDataType;
import shaded.org.apache.tsfile.exception.encoding.TsFileDecodingException;
import shaded.org.apache.tsfile.file.metadata.enums.TSEncoding;
import shaded.org.apache.tsfile.utils.Binary;

public abstract class Decoder {
    private static final String ERROR_MSG = "Decoder not found: %s , DataType is : %s";
    private TSEncoding type;

    public Decoder(TSEncoding type) {
        this.type = type;
    }

    public void setType(TSEncoding type) {
        this.type = type;
    }

    public TSEncoding getType() {
        return this.type;
    }

    public static Decoder getDecoderByType(TSEncoding encoding, TSDataType dataType) {
        switch (encoding) {
            case PLAIN: {
                return new PlainDecoder();
            }
            case RLE: {
                switch (dataType) {
                    case BOOLEAN: 
                    case INT32: 
                    case DATE: {
                        return new IntRleDecoder();
                    }
                    case INT64: 
                    case VECTOR: 
                    case TIMESTAMP: {
                        return new LongRleDecoder();
                    }
                    case FLOAT: 
                    case DOUBLE: {
                        return new FloatDecoder(TSEncoding.valueOf(encoding.toString()), dataType);
                    }
                }
                throw new TsFileDecodingException(String.format(ERROR_MSG, new Object[]{encoding, dataType}));
            }
            case TS_2DIFF: {
                switch (dataType) {
                    case INT32: 
                    case DATE: {
                        return new DeltaBinaryDecoder.IntDeltaDecoder();
                    }
                    case INT64: 
                    case VECTOR: 
                    case TIMESTAMP: {
                        return new DeltaBinaryDecoder.LongDeltaDecoder();
                    }
                    case FLOAT: 
                    case DOUBLE: {
                        return new FloatDecoder(TSEncoding.valueOf(encoding.toString()), dataType);
                    }
                }
                throw new TsFileDecodingException(String.format(ERROR_MSG, new Object[]{encoding, dataType}));
            }
            case GORILLA_V1: {
                switch (dataType) {
                    case FLOAT: {
                        return new SinglePrecisionDecoderV1();
                    }
                    case DOUBLE: {
                        return new DoublePrecisionDecoderV1();
                    }
                }
                throw new TsFileDecodingException(String.format(ERROR_MSG, new Object[]{encoding, dataType}));
            }
            case REGULAR: {
                switch (dataType) {
                    case INT32: 
                    case DATE: {
                        return new RegularDataDecoder.IntRegularDecoder();
                    }
                    case INT64: 
                    case VECTOR: 
                    case TIMESTAMP: {
                        return new RegularDataDecoder.LongRegularDecoder();
                    }
                }
                throw new TsFileDecodingException(String.format(ERROR_MSG, new Object[]{encoding, dataType}));
            }
            case GORILLA: {
                switch (dataType) {
                    case FLOAT: {
                        return new SinglePrecisionDecoderV2();
                    }
                    case DOUBLE: {
                        return new DoublePrecisionDecoderV2();
                    }
                    case INT32: 
                    case DATE: {
                        return new IntGorillaDecoder();
                    }
                    case INT64: 
                    case VECTOR: 
                    case TIMESTAMP: {
                        return new LongGorillaDecoder();
                    }
                }
                throw new TsFileDecodingException(String.format(ERROR_MSG, new Object[]{encoding, dataType}));
            }
            case DICTIONARY: {
                return new DictionaryDecoder();
            }
            case ZIGZAG: {
                switch (dataType) {
                    case INT32: 
                    case DATE: {
                        return new IntZigzagDecoder();
                    }
                    case INT64: 
                    case TIMESTAMP: {
                        return new LongZigzagDecoder();
                    }
                }
                throw new TsFileDecodingException(String.format(ERROR_MSG, new Object[]{encoding, dataType}));
            }
            case CHIMP: {
                switch (dataType) {
                    case FLOAT: {
                        return new SinglePrecisionChimpDecoder();
                    }
                    case DOUBLE: {
                        return new DoublePrecisionChimpDecoder();
                    }
                    case INT32: 
                    case DATE: {
                        return new IntChimpDecoder();
                    }
                    case INT64: 
                    case VECTOR: 
                    case TIMESTAMP: {
                        return new LongChimpDecoder();
                    }
                }
                throw new TsFileDecodingException(String.format(ERROR_MSG, new Object[]{encoding, dataType}));
            }
            case SPRINTZ: {
                switch (dataType) {
                    case INT32: 
                    case DATE: {
                        return new IntSprintzDecoder();
                    }
                    case INT64: 
                    case TIMESTAMP: {
                        return new LongSprintzDecoder();
                    }
                    case FLOAT: {
                        return new FloatSprintzDecoder();
                    }
                    case DOUBLE: {
                        return new DoubleSprintzDecoder();
                    }
                }
                throw new TsFileDecodingException(String.format(ERROR_MSG, new Object[]{encoding, dataType}));
            }
            case RLBE: {
                switch (dataType) {
                    case INT32: 
                    case DATE: {
                        return new IntRLBEDecoder();
                    }
                    case INT64: 
                    case TIMESTAMP: {
                        return new LongRLBEDecoder();
                    }
                    case FLOAT: {
                        return new FloatRLBEDecoder();
                    }
                    case DOUBLE: {
                        return new DoubleRLBEDecoder();
                    }
                }
                throw new TsFileDecodingException(String.format(ERROR_MSG, new Object[]{encoding, dataType}));
            }
            case CAMEL: {
                switch (dataType) {
                    case DOUBLE: {
                        return new CamelDecoder();
                    }
                }
                throw new TsFileDecodingException(String.format(ERROR_MSG, new Object[]{encoding, dataType}));
            }
        }
        throw new TsFileDecodingException(String.format(ERROR_MSG, new Object[]{encoding, dataType}));
    }

    public int readInt(ByteBuffer buffer) {
        throw new TsFileDecodingException("Method readInt is not supported by Decoder");
    }

    public boolean readBoolean(ByteBuffer buffer) {
        throw new TsFileDecodingException("Method readBoolean is not supported by Decoder");
    }

    public short readShort(ByteBuffer buffer) {
        throw new TsFileDecodingException("Method readShort is not supported by Decoder");
    }

    public long readLong(ByteBuffer buffer) {
        throw new TsFileDecodingException("Method readLong is not supported by Decoder");
    }

    public float readFloat(ByteBuffer buffer) {
        throw new TsFileDecodingException("Method readFloat is not supported by Decoder");
    }

    public double readDouble(ByteBuffer buffer) {
        throw new TsFileDecodingException("Method readDouble is not supported by Decoder");
    }

    public Binary readBinary(ByteBuffer buffer) {
        throw new TsFileDecodingException("Method readBinary is not supported by Decoder");
    }

    public BigDecimal readBigDecimal(ByteBuffer buffer) {
        throw new TsFileDecodingException("Method readBigDecimal is not supported by Decoder");
    }

    public abstract boolean hasNext(ByteBuffer var1) throws IOException;

    public abstract void reset();
}

