/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.tsfile.encoding.decoder;

import java.nio.ByteBuffer;
import shaded.org.apache.tsfile.encoding.decoder.GorillaDecoderV2;

public class IntGorillaDecoder
extends GorillaDecoderV2 {
    protected int storedValue = 0;

    @Override
    public void reset() {
        super.reset();
        this.storedValue = 0;
    }

    @Override
    public final int readInt(ByteBuffer in) {
        int returnValue = this.storedValue;
        if (!this.firstValueWasRead) {
            this.flipByte(in);
            this.storedValue = (int)this.readLong(32, in);
            this.firstValueWasRead = true;
            returnValue = this.storedValue;
        }
        this.cacheNext(in);
        return returnValue;
    }

    protected int cacheNext(ByteBuffer in) {
        this.readNext(in);
        if (this.storedValue == Integer.MIN_VALUE) {
            this.hasNext = false;
        }
        return this.storedValue;
    }

    protected int readNext(ByteBuffer in) {
        byte controlBits = this.readNextClearBit(2, in);
        switch (controlBits) {
            case 3: {
                this.storedLeadingZeros = (int)this.readLong(5, in);
                byte significantBits = (byte)this.readLong(5, in);
                significantBits = (byte)(significantBits + 1);
                this.storedTrailingZeros = 32 - significantBits - this.storedLeadingZeros;
            }
            case 2: {
                int xor = (int)this.readLong(32 - this.storedLeadingZeros - this.storedTrailingZeros, in);
                this.storedValue ^= (xor <<= this.storedTrailingZeros);
            }
        }
        return this.storedValue;
    }
}

