/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.tsfile.encoding.decoder;

import java.nio.ByteBuffer;
import shaded.org.apache.tsfile.encoding.decoder.Decoder;
import shaded.org.apache.tsfile.file.metadata.enums.TSEncoding;

public class IntRLBEDecoder
extends Decoder {
    private int blocksize;
    private int[] data;
    private int writeindex = -1;
    private int readindex = -1;
    private int[] fibonacci;
    private byte byteBuffer = 0;
    private int numberLeftInBuffer = 0;

    public IntRLBEDecoder() {
        super(TSEncoding.RLBE);
    }

    private void readhead(ByteBuffer buffer) {
        int i;
        for (i = 0; i <= this.writeindex; ++i) {
            this.data[i] = 0;
        }
        this.writeindex = -1;
        this.readindex = -1;
        this.clearBuffer(buffer);
        this.readblocksize(buffer);
        this.data = new int[this.blocksize * 2 + 1];
        this.fibonacci = new int[this.blocksize * 2 + 1];
        for (i = 0; i < this.blocksize * 2; ++i) {
            this.data[i] = 0;
            this.fibonacci[i] = 0;
        }
        this.fibonacci[0] = 1;
        this.fibonacci[1] = 1;
    }

    private void readT(ByteBuffer buffer) {
        this.readhead(buffer);
        while (this.writeindex < this.blocksize - 1) {
            int seglength = 0;
            int runlength = 0;
            for (int j = 5; j >= 0; --j) {
                seglength |= this.readbit(buffer) << j;
            }
            int now = this.readbit(buffer);
            int next = this.readbit(buffer);
            int j = 1;
            while (true) {
                if (j > 1) {
                    this.fibonacci[j] = this.fibonacci[j - 1] + this.fibonacci[j - 2];
                }
                if (now == 1) {
                    runlength += this.fibonacci[j];
                }
                if (now == 1 && next == 1) break;
                ++j;
                now = next;
                next = this.readbit(buffer);
            }
            for (int i = 1; i <= runlength; ++i) {
                int readinttemp = 0;
                for (int k = seglength - 1; k >= 0; --k) {
                    readinttemp += this.readbit(buffer) << k;
                }
                if (seglength == 32) {
                    readinttemp -= Integer.MIN_VALUE;
                }
                if (this.writeindex == -1) {
                    this.data[++this.writeindex] = readinttemp;
                    continue;
                }
                ++this.writeindex;
                this.data[this.writeindex] = this.data[this.writeindex - 1] + readinttemp;
            }
        }
    }

    @Override
    public int readInt(ByteBuffer buffer) {
        if (this.readindex < this.writeindex) {
            return this.data[++this.readindex];
        }
        this.readT(buffer);
        return this.data[++this.readindex];
    }

    @Override
    public boolean hasNext(ByteBuffer buffer) {
        return buffer.remaining() > 0 || this.readindex < this.writeindex;
    }

    @Override
    public void reset() {
    }

    private int readbit(ByteBuffer buffer) {
        if (this.numberLeftInBuffer == 0) {
            this.loadBuffer(buffer);
            this.numberLeftInBuffer = 8;
        }
        int top = this.byteBuffer >> 7 & 1;
        this.byteBuffer = (byte)(this.byteBuffer << 1);
        --this.numberLeftInBuffer;
        return top;
    }

    private void loadBuffer(ByteBuffer buffer) {
        this.byteBuffer = buffer.get();
    }

    private void clearBuffer(ByteBuffer buffer) {
        while (this.numberLeftInBuffer > 0) {
            this.readbit(buffer);
        }
    }

    private void readblocksize(ByteBuffer buffer) {
        this.blocksize = 0;
        for (int i = 31; i >= 0; --i) {
            if (this.readbit(buffer) != 1) continue;
            this.blocksize |= 1 << i;
        }
    }
}

