/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.tsfile.encoding.decoder;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import shaded.org.apache.tsfile.common.conf.TSFileDescriptor;
import shaded.org.apache.tsfile.encoding.bitpacking.IntPacker;
import shaded.org.apache.tsfile.encoding.decoder.IntRleDecoder;
import shaded.org.apache.tsfile.encoding.decoder.SprintzDecoder;
import shaded.org.apache.tsfile.encoding.fire.IntFire;
import shaded.org.apache.tsfile.utils.ReadWriteForEncodingUtils;

public class IntSprintzDecoder
extends SprintzDecoder {
    IntPacker packer;
    IntFire firePred;
    private int preValue;
    private final int[] currentBuffer;
    private int currentValue;
    private final String predictScheme = TSFileDescriptor.getInstance().getConfig().getSprintzPredictScheme();

    public IntSprintzDecoder() {
        this.currentBuffer = new int[this.Block_size + 1];
        this.firePred = new IntFire(2);
        this.reset();
    }

    @Override
    public boolean hasNext(ByteBuffer buffer) throws IOException {
        int minLenth = 5;
        return this.isBlockReaded && this.currentCount < this.Block_size || buffer.remaining() >= minLenth;
    }

    @Override
    public void reset() {
        super.reset();
        this.currentValue = 0;
        this.preValue = 0;
        this.currentCount = 0;
        Arrays.fill(this.currentBuffer, 0);
    }

    @Override
    protected void decodeBlock(ByteBuffer in) throws IOException {
        this.bitWidth = ReadWriteForEncodingUtils.readIntLittleEndianPaddedOnBitWidth(in, 1);
        if ((this.bitWidth & 0x80) != 0) {
            this.decodeSize = this.bitWidth & 0xFFFFFF7F;
            IntRleDecoder decoder = new IntRleDecoder();
            for (int i = 0; i < this.decodeSize; ++i) {
                this.currentBuffer[i] = decoder.readInt(in);
            }
        } else {
            int i;
            this.decodeSize = this.Block_size + 1;
            this.currentBuffer[0] = this.preValue = ReadWriteForEncodingUtils.readUnsignedVarInt(in);
            int[] tmpBuffer = new int[8];
            this.packer = new IntPacker(this.bitWidth);
            byte[] packcle = new byte[this.bitWidth];
            for (i = 0; i < this.bitWidth; ++i) {
                packcle[i] = in.get();
            }
            this.packer.unpack8Values(packcle, 0, tmpBuffer);
            for (i = 0; i < 8; ++i) {
                this.currentBuffer[i + 1] = tmpBuffer[i];
            }
            this.recalculate();
        }
        this.isBlockReaded = true;
    }

    @Override
    protected void recalculate() {
        int i;
        for (i = 1; i <= this.Block_size; ++i) {
            this.currentBuffer[i] = this.currentBuffer[i] % 2 == 0 ? -this.currentBuffer[i] / 2 : (this.currentBuffer[i] + 1) / 2;
        }
        if (this.predictScheme.equals("delta")) {
            for (i = 1; i < this.currentBuffer.length; ++i) {
                int n = i;
                this.currentBuffer[n] = this.currentBuffer[n] + this.currentBuffer[i - 1];
            }
        } else if (this.predictScheme.equals("fire")) {
            this.firePred.reset();
            int pre = this.currentBuffer[0];
            for (int i2 = 1; i2 <= this.Block_size; ++i2) {
                int pred = this.firePred.predict(this.currentBuffer[i2 - 1]);
                int err = this.currentBuffer[i2];
                this.currentBuffer[i2] = pred + err;
                this.firePred.train(this.currentBuffer[i2 - 1], this.currentBuffer[i2], err);
            }
        } else {
            throw new UnsupportedOperationException("Sprintz predictive method {} is not supported.");
        }
    }

    @Override
    public int readInt(ByteBuffer buffer) {
        if (!this.isBlockReaded) {
            try {
                this.decodeBlock(buffer);
            }
            catch (IOException e) {
                logger.error("Error occured when readInt with Sprintz Decoder.", e);
            }
        }
        this.currentValue = this.currentBuffer[this.currentCount++];
        if (this.currentCount == this.decodeSize) {
            this.isBlockReaded = false;
            this.currentCount = 0;
        }
        return this.currentValue;
    }
}

