/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.tsfile.encoding.decoder;

import java.nio.ByteBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import shaded.org.apache.tsfile.encoding.decoder.Decoder;
import shaded.org.apache.tsfile.file.metadata.enums.TSEncoding;
import shaded.org.apache.tsfile.utils.ReadWriteForEncodingUtils;

public class IntZigzagDecoder
extends Decoder {
    private static final Logger logger = LoggerFactory.getLogger(IntZigzagDecoder.class);
    private int length;
    private int number;
    private int currentCount;
    private ByteBuffer byteCache;

    public IntZigzagDecoder() {
        super(TSEncoding.ZIGZAG);
        this.reset();
        logger.debug("tsfile-decoding IntZigzagDecoder: int zigzag decoder");
    }

    @Override
    public int readInt(ByteBuffer buffer) {
        if (this.currentCount == 0) {
            this.reset();
            this.getLengthAndNumber(buffer);
            this.currentCount = this.number;
        }
        int n = ReadWriteForEncodingUtils.readUnsignedVarInt(this.byteCache);
        --this.currentCount;
        return n >>> 1 ^ -(n & 1);
    }

    private void getLengthAndNumber(ByteBuffer buffer) {
        this.length = ReadWriteForEncodingUtils.readUnsignedVarInt(buffer);
        this.number = ReadWriteForEncodingUtils.readUnsignedVarInt(buffer);
        byte[] tmp = new byte[this.length];
        buffer.get(tmp, 0, this.length);
        this.byteCache = ByteBuffer.wrap(tmp);
    }

    @Override
    public boolean hasNext(ByteBuffer buffer) {
        return this.currentCount > 0 || buffer.remaining() > 0;
    }

    @Override
    public void reset() {
        this.length = 0;
        this.number = 0;
        this.currentCount = 0;
        if (this.byteCache == null) {
            this.byteCache = ByteBuffer.allocate(0);
        } else {
            this.byteCache.position(0);
        }
    }
}

