/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.tsfile.encoding.decoder;

import java.nio.ByteBuffer;
import shaded.org.apache.tsfile.encoding.decoder.GorillaDecoderV2;
import shaded.org.apache.tsfile.file.metadata.enums.TSEncoding;

public class LongChimpDecoder
extends GorillaDecoderV2 {
    private static final short[] LEADING_REPRESENTATION = new short[]{0, 8, 12, 16, 18, 20, 22, 24};
    private static final int PREVIOUS_VALUES = 128;
    private static final int PREVIOUS_VALUES_LOG2 = (int)(Math.log(128.0) / Math.log(2.0));
    private static final int CASE_ONE_METADATA_LENGTH = PREVIOUS_VALUES_LOG2 + 9;
    private long storedValue = 0L;
    protected long[] storedValues = new long[128];
    protected int current = 0;

    public LongChimpDecoder() {
        this.setType(TSEncoding.CHIMP);
        this.hasNext = true;
        this.firstValueWasRead = false;
        this.storedLeadingZeros = Integer.MAX_VALUE;
        this.storedTrailingZeros = 0;
        this.current = 0;
        this.storedValue = 0L;
        this.storedValues = new long[128];
    }

    @Override
    public void reset() {
        super.reset();
        this.current = 0;
        this.storedValue = 0L;
        this.storedValues = new long[128];
    }

    @Override
    public final long readLong(ByteBuffer in) {
        long returnValue = this.storedValue;
        if (!this.firstValueWasRead) {
            this.flipByte(in);
            this.storedValues[this.current] = this.storedValue = this.readLong(64, in);
            this.firstValueWasRead = true;
            returnValue = this.storedValue;
        }
        this.cacheNext(in);
        return returnValue;
    }

    protected long cacheNext(ByteBuffer in) {
        this.readNext(in);
        if (this.storedValues[this.current] == Long.MIN_VALUE) {
            this.hasNext = false;
        }
        return this.storedValues[this.current];
    }

    protected long readNext(ByteBuffer in) {
        byte controlBits = this.readNextNBits(2, in);
        switch (controlBits) {
            case 3: {
                this.storedLeadingZeros = LEADING_REPRESENTATION[(int)this.readLong(3, in)];
                long value = this.readLong(64 - this.storedLeadingZeros, in);
                this.storedValue ^= value;
                this.current = (this.current + 1) % 128;
                this.storedValues[this.current] = this.storedValue;
                return this.storedValue;
            }
            case 2: {
                long value = this.readLong(64 - this.storedLeadingZeros, in);
                this.storedValue ^= value;
                this.current = (this.current + 1) % 128;
                this.storedValues[this.current] = this.storedValue;
                return this.storedValue;
            }
            case 1: {
                int fill = CASE_ONE_METADATA_LENGTH;
                int temp = (int)this.readLong(fill, in);
                int index = temp >>> (fill -= PREVIOUS_VALUES_LOG2) & (1 << PREVIOUS_VALUES_LOG2) - 1;
                this.storedLeadingZeros = LEADING_REPRESENTATION[temp >>> (fill -= 3) & 7];
                int significantBits = temp >>> (fill -= 6) & 0x3F;
                this.storedValue = this.storedValues[index];
                if (significantBits == 0) {
                    significantBits = 64;
                }
                this.storedTrailingZeros = 64 - significantBits - this.storedLeadingZeros;
                long value = this.readLong(64 - this.storedLeadingZeros - this.storedTrailingZeros, in);
                this.storedValue ^= (value <<= this.storedTrailingZeros);
                this.current = (this.current + 1) % 128;
                this.storedValues[this.current] = this.storedValue;
                return this.storedValue;
            }
        }
        int previousIndex = (int)this.readLong(PREVIOUS_VALUES_LOG2, in);
        this.storedValue = this.storedValues[previousIndex];
        this.current = (this.current + 1) % 128;
        this.storedValues[this.current] = this.storedValue;
        return this.storedValue;
    }

    private byte readNextNBits(int n, ByteBuffer in) {
        byte value = 0;
        for (int i = 0; i < n; ++i) {
            value = (byte)(value << 1);
            if (!this.readBit(in)) continue;
            value = (byte)(value | 1);
        }
        return value;
    }
}

