/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.tsfile.encoding.decoder;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.BitSet;
import shaded.org.apache.tsfile.encoding.decoder.Decoder;
import shaded.org.apache.tsfile.file.metadata.enums.TSEncoding;
import shaded.org.apache.tsfile.utils.ReadWriteIOUtils;

public abstract class RegularDataDecoder
extends Decoder {
    protected int readIntTotalCount = 0;
    protected int nextReadIndex = 0;
    protected int packNum;

    public RegularDataDecoder() {
        super(TSEncoding.REGULAR);
    }

    protected abstract void readHeader(ByteBuffer var1) throws IOException;

    protected abstract void allocateDataArray();

    protected abstract void readValue(int var1);

    @Override
    public boolean hasNext(ByteBuffer buffer) throws IOException {
        return this.nextReadIndex < this.readIntTotalCount || buffer.remaining() > 0;
    }

    public static class LongRegularDecoder
    extends RegularDataDecoder {
        private long[] data;
        private long firstValue;
        private long previous;
        private boolean isMissingPoint;
        private BitSet bitmap;
        private int bitmapIndex;
        private long minDeltaBase;

        protected long readT(ByteBuffer buffer) {
            if (this.nextReadIndex == this.readIntTotalCount) {
                this.isMissingPoint = ReadWriteIOUtils.readBool(buffer);
                if (this.isMissingPoint) {
                    this.readBitmap(buffer);
                }
                return this.loadIntBatch(buffer);
            }
            if (this.isMissingPoint) {
                ++this.bitmapIndex;
                return this.loadWithBitmap(buffer);
            }
            return this.data[this.nextReadIndex++];
        }

        private void readBitmap(ByteBuffer buffer) {
            int length = ReadWriteIOUtils.readInt(buffer);
            byte[] byteArr = new byte[length];
            buffer.get(byteArr);
            this.bitmap = BitSet.valueOf(byteArr);
            this.bitmapIndex = 0;
        }

        protected long loadWithBitmap(ByteBuffer buffer) {
            while (!this.bitmap.get(this.bitmapIndex)) {
                ++this.bitmapIndex;
            }
            this.nextReadIndex = this.bitmapIndex - 1;
            return this.data[this.nextReadIndex];
        }

        protected long loadIntBatch(ByteBuffer buffer) {
            this.packNum = ReadWriteIOUtils.readInt(buffer);
            this.readHeader(buffer);
            this.allocateDataArray();
            this.readIntTotalCount = this.isMissingPoint ? this.packNum - 2 : this.packNum - 1;
            this.previous = this.firstValue;
            this.nextReadIndex = 0;
            this.readPack();
            return this.firstValue;
        }

        private void readPack() {
            for (int i = 0; i < this.data.length; ++i) {
                this.readValue(i);
                this.previous = this.data[i];
            }
        }

        @Override
        public long readLong(ByteBuffer buffer) {
            return this.readT(buffer);
        }

        @Override
        protected void readHeader(ByteBuffer buffer) {
            this.minDeltaBase = ReadWriteIOUtils.readLong(buffer);
            this.firstValue = ReadWriteIOUtils.readLong(buffer);
        }

        @Override
        protected void allocateDataArray() {
            this.data = new long[this.packNum - 1];
        }

        @Override
        protected void readValue(int i) {
            this.data[i] = this.previous + this.minDeltaBase;
        }

        @Override
        public void reset() {
        }
    }

    public static class IntRegularDecoder
    extends RegularDataDecoder {
        private int[] data;
        private int firstValue;
        private int previous;
        private boolean isMissingPoint;
        private BitSet bitmap;
        private int bitmapIndex;
        private int minDeltaBase;

        protected int readT(ByteBuffer buffer) {
            if (this.nextReadIndex == this.readIntTotalCount) {
                this.isMissingPoint = ReadWriteIOUtils.readBool(buffer);
                if (this.isMissingPoint) {
                    this.readBitmap(buffer);
                }
                return this.loadIntBatch(buffer);
            }
            if (this.isMissingPoint) {
                ++this.bitmapIndex;
                return this.loadWithBitmap(buffer);
            }
            return this.data[this.nextReadIndex++];
        }

        private void readBitmap(ByteBuffer buffer) {
            int length = ReadWriteIOUtils.readInt(buffer);
            byte[] byteArr = new byte[length];
            buffer.get(byteArr);
            this.bitmap = BitSet.valueOf(byteArr);
            this.bitmapIndex = 0;
        }

        protected int loadWithBitmap(ByteBuffer buffer) {
            while (!this.bitmap.get(this.bitmapIndex)) {
                ++this.bitmapIndex;
            }
            this.nextReadIndex = this.bitmapIndex - 1;
            return this.data[this.nextReadIndex];
        }

        protected int loadIntBatch(ByteBuffer buffer) {
            this.packNum = ReadWriteIOUtils.readInt(buffer);
            this.readHeader(buffer);
            this.allocateDataArray();
            this.readIntTotalCount = this.isMissingPoint ? this.packNum - 2 : this.packNum - 1;
            this.previous = this.firstValue;
            this.nextReadIndex = 0;
            this.readPack();
            return this.firstValue;
        }

        private void readPack() {
            for (int i = 0; i < this.data.length; ++i) {
                this.readValue(i);
                this.previous = this.data[i];
            }
        }

        @Override
        public int readInt(ByteBuffer buffer) {
            return this.readT(buffer);
        }

        @Override
        protected void readHeader(ByteBuffer buffer) {
            this.minDeltaBase = ReadWriteIOUtils.readInt(buffer);
            this.firstValue = ReadWriteIOUtils.readInt(buffer);
        }

        @Override
        protected void allocateDataArray() {
            this.data = new int[this.packNum - 1];
        }

        @Override
        protected void readValue(int i) {
            this.data[i] = this.previous + this.minDeltaBase;
        }

        @Override
        public void reset() {
        }
    }
}

