/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.tsfile.encoding.decoder;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import shaded.org.apache.tsfile.encoding.decoder.GorillaDecoderV1;
import shaded.org.apache.tsfile.utils.ReadWriteIOUtils;

public class SinglePrecisionDecoderV1
extends GorillaDecoderV1 {
    private static final Logger logger = LoggerFactory.getLogger(SinglePrecisionDecoderV1.class);
    private int preValue;

    @Override
    public float readFloat(ByteBuffer buffer) {
        if (!this.flag) {
            this.flag = true;
            try {
                int ch1 = ReadWriteIOUtils.read(buffer);
                int ch2 = ReadWriteIOUtils.read(buffer);
                int ch3 = ReadWriteIOUtils.read(buffer);
                int ch4 = ReadWriteIOUtils.read(buffer);
                this.preValue = ch1 + (ch2 << 8) + (ch3 << 16) + (ch4 << 24);
                this.leadingZeroNum = Integer.numberOfLeadingZeros(this.preValue);
                this.tailingZeroNum = Integer.numberOfTrailingZeros(this.preValue);
                float tmp = Float.intBitsToFloat(this.preValue);
                this.fillBuffer(buffer);
                this.getNextValue(buffer);
                return tmp;
            }
            catch (IOException e) {
                logger.error("SinglePrecisionDecoderV1 cannot read first float number", e);
            }
        } else {
            try {
                float tmp = Float.intBitsToFloat(this.preValue);
                this.getNextValue(buffer);
                return tmp;
            }
            catch (IOException e) {
                logger.error("SinglePrecisionDecoderV1 cannot read following float number", e);
            }
        }
        return Float.NaN;
    }

    private void getNextValue(ByteBuffer buffer) throws IOException {
        this.nextFlag1 = this.readBit(buffer);
        if (!this.nextFlag1) {
            return;
        }
        this.nextFlag2 = this.readBit(buffer);
        if (!this.nextFlag2) {
            int tmp = 0;
            for (int i = 0; i < 32 - this.leadingZeroNum - this.tailingZeroNum; ++i) {
                int bit = this.readBit(buffer) ? 1 : 0;
                tmp |= bit << 31 - this.leadingZeroNum - i;
            }
            this.preValue = tmp ^= this.preValue;
        } else {
            int leadingZeroNumTmp = this.readIntFromStream(buffer, 5);
            int lenTmp = this.readIntFromStream(buffer, 6);
            int tmp = this.readIntFromStream(buffer, lenTmp);
            tmp <<= 32 - leadingZeroNumTmp - lenTmp;
            this.preValue = tmp ^= this.preValue;
        }
        this.leadingZeroNum = Integer.numberOfLeadingZeros(this.preValue);
        this.tailingZeroNum = Integer.numberOfTrailingZeros(this.preValue);
        if (Float.isNaN(Float.intBitsToFloat(this.preValue))) {
            this.isEnd = true;
        }
    }
}

