/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.tsfile.encoding.encoder;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import shaded.org.apache.tsfile.common.bitStream.BitOutputStream;
import shaded.org.apache.tsfile.encoding.encoder.Encoder;
import shaded.org.apache.tsfile.file.metadata.enums.TSEncoding;
import shaded.org.apache.tsfile.utils.ReadWriteForEncodingUtils;

public class CamelEncoder
extends Encoder {
    private final GorillaEncoder gorillaEncoder;
    private static final int BITS_FOR_SIGN = 1;
    private static final int BITS_FOR_TYPE = 1;
    private static final int BITS_FOR_FIRST_VALUE = 64;
    private static final int BITS_FOR_LEADING_ZEROS = 6;
    private static final int BITS_FOR_SIGNIFICANT_BITS = 6;
    private static final int BITS_FOR_DECIMAL_COUNT = 4;
    private static final int DOUBLE_TOTAL_BITS = 64;
    private static final int DOUBLE_MANTISSA_BITS = 52;
    private static final int DECIMAL_MAX_COUNT = 10;
    private long storedVal = 0L;
    private boolean isFirst = true;
    long previousValue = 0L;
    private boolean hasPending = false;
    public static final long[] powers = new long[10];
    public static final long[] threshold = new long[10];
    private final BitOutputStream out;
    private final ByteArrayOutputStream baos = new ByteArrayOutputStream();

    public CamelEncoder() {
        super(TSEncoding.CAMEL);
        this.out = new BitOutputStream(this.baos);
        this.gorillaEncoder = new GorillaEncoder();
    }

    @Override
    public void encode(double value, ByteArrayOutputStream out) {
        try {
            this.addValue(value);
            this.hasPending = true;
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void flush(ByteArrayOutputStream out) throws IOException {
        if (!this.hasPending) {
            return;
        }
        int writtenBits = this.close();
        ReadWriteForEncodingUtils.writeVarInt(writtenBits, out);
        this.baos.writeTo(out);
        this.baos.reset();
        this.out.reset(this.baos);
        this.resetState();
        this.hasPending = false;
    }

    private void resetState() {
        this.isFirst = true;
        this.storedVal = 0L;
        this.previousValue = 0L;
        this.hasPending = false;
        this.gorillaEncoder.leadingZeros = Integer.MAX_VALUE;
        this.gorillaEncoder.trailingZeros = 0;
    }

    @Override
    public int getOneItemMaxSize() {
        return 8;
    }

    @Override
    public long getMaxByteSize() {
        return 1 + this.baos.size() + 8 + 8;
    }

    public void addValue(double value) throws IOException {
        if (this.isFirst) {
            this.writeFirst(Double.doubleToRawLongBits(value));
        } else {
            this.compressValue(value);
        }
        this.previousValue = Double.doubleToLongBits(value);
    }

    private void writeFirst(long value) throws IOException {
        this.isFirst = false;
        this.storedVal = (long)Double.longBitsToDouble(value);
        this.out.writeLong(value, 64);
    }

    public int close() throws IOException {
        this.out.close();
        return this.out.getBitsWritten();
    }

    private void compressValue(double value) throws IOException {
        int signBit = (int)(Double.doubleToLongBits(value) >>> 63 & 1L);
        this.out.writeInt(signBit, 1);
        value = Math.abs(value);
        if (value > 9.223372036854776E18 || value == 0.0 || Math.abs(Math.floor(Math.log10(value))) > 10.0) {
            this.out.writeInt(CamelInnerEncodingType.GORILLA.getCode(), 1);
            this.gorillaEncoder.encode(value, this.out);
            return;
        }
        long integerPart = (long)value;
        int numDigits = 1;
        long absInt = Math.abs(integerPart);
        while (absInt >= 10L) {
            absInt /= 10L;
            ++numDigits;
        }
        double factor = 1.0;
        int decimalCount = 0;
        while (Math.abs(value * factor - (double)Math.round(value * factor)) > 0.0) {
            factor *= 10.0;
            if (numDigits + ++decimalCount <= 10) continue;
        }
        if ((decimalCount = Math.max(1, decimalCount)) + numDigits <= 10) {
            long pow = powers[decimalCount - 1];
            long decimalValue = Math.round(value * (double)pow) % pow;
            this.out.writeInt(CamelInnerEncodingType.CAMEL.getCode(), 1);
            this.compressIntegerValue(integerPart);
            this.compressDecimalValue(decimalValue, decimalCount);
        } else {
            this.out.writeInt(CamelInnerEncodingType.GORILLA.getCode(), 1);
            this.gorillaEncoder.encode(value, this.out);
        }
    }

    private void compressIntegerValue(long value) throws IOException {
        long diff = value - this.storedVal;
        this.storedVal = value;
        BitOutputStream.writeVarLong(diff, this.out);
    }

    private void compressDecimalValue(long decimalValue, int decimalCount) throws IOException {
        this.out.writeInt(decimalCount - 1, 4);
        long thresh = threshold[decimalCount - 1];
        int m = (int)decimalValue;
        if (decimalValue >= thresh) {
            this.out.writeBit(true);
            m = (int)(decimalValue % thresh);
            long xor = Double.doubleToLongBits((double)decimalValue / (double)powers[decimalCount - 1] + 1.0) ^ Double.doubleToLongBits((double)m / (double)powers[decimalCount - 1] + 1.0);
            this.out.writeLong(xor >>> 52 - decimalCount, decimalCount);
        } else {
            this.out.writeBit(false);
        }
        BitOutputStream.writeVarLong(m, this.out);
    }

    public int getWrittenBits() {
        return this.out.getBitsWritten();
    }

    public ByteArrayOutputStream getByteArrayOutputStream() {
        return this.baos;
    }

    public GorillaEncoder getGorillaEncoder() {
        return this.gorillaEncoder;
    }

    static {
        for (int l = 1; l <= 10; ++l) {
            int idx = l - 1;
            CamelEncoder.powers[idx] = (long)Math.pow(10.0, l);
            long divisor = 1L << l;
            CamelEncoder.threshold[idx] = powers[idx] / divisor;
        }
    }

    public class GorillaEncoder {
        private int leadingZeros = Integer.MAX_VALUE;
        private int trailingZeros = 0;

        public void encode(double value, BitOutputStream out) throws IOException {
            long curr = Double.doubleToLongBits(value);
            if (CamelEncoder.this.isFirst) {
                out.writeLong(curr, 64);
                CamelEncoder.this.previousValue = curr;
                CamelEncoder.this.isFirst = false;
                return;
            }
            long xor = curr ^ CamelEncoder.this.previousValue;
            if (xor == 0L) {
                out.writeBit(false);
            } else {
                out.writeBit(true);
                int leading = Long.numberOfLeadingZeros(xor);
                int trailing = Long.numberOfTrailingZeros(xor);
                if (leading >= this.leadingZeros && trailing >= this.trailingZeros) {
                    out.writeBit(false);
                    int significantBits = 64 - this.leadingZeros - this.trailingZeros;
                    out.writeLong(xor >>> this.trailingZeros, significantBits);
                } else {
                    out.writeBit(true);
                    out.writeInt(leading, 6);
                    int significantBits = 64 - leading - trailing;
                    out.writeInt(significantBits - 1, 6);
                    out.writeLong(xor >>> trailing, significantBits);
                    this.leadingZeros = leading;
                    this.trailingZeros = trailing;
                }
            }
            CamelEncoder.this.previousValue = curr;
        }

        public void close(BitOutputStream out) throws IOException {
            out.close();
        }
    }

    public static enum CamelInnerEncodingType {
        GORILLA(0),
        CAMEL(1);

        private final int code;

        private CamelInnerEncodingType(int code) {
            this.code = code;
        }

        public int getCode() {
            return this.code;
        }
    }
}

