/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.tsfile.encoding.encoder;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import shaded.org.apache.tsfile.encoding.encoder.Encoder;
import shaded.org.apache.tsfile.file.metadata.enums.TSEncoding;
import shaded.org.apache.tsfile.utils.BytesUtils;
import shaded.org.apache.tsfile.utils.ReadWriteIOUtils;

public abstract class DeltaBinaryEncoder
extends Encoder {
    protected static final int BLOCK_DEFAULT_SIZE = 128;
    private static final Logger logger = LoggerFactory.getLogger(DeltaBinaryEncoder.class);
    protected ByteArrayOutputStream out;
    protected int blockSize;
    protected byte[] encodingBlockBuffer;
    protected int writeIndex = -1;
    protected int writeWidth = 0;

    protected DeltaBinaryEncoder(int size) {
        super(TSEncoding.TS_2DIFF);
        this.blockSize = size;
    }

    protected abstract void writeHeader() throws IOException;

    protected abstract void writeValueToBytes(int var1);

    protected abstract void calcTwoDiff(int var1);

    protected abstract void reset();

    protected abstract int calculateBitWidthsForDeltaBlockBuffer();

    private void writeDataWithMinWidth() {
        for (int i = 0; i < this.writeIndex; ++i) {
            this.writeValueToBytes(i);
        }
        int encodingLength = (int)Math.ceil((double)(this.writeIndex * this.writeWidth) / 8.0);
        this.out.write(this.encodingBlockBuffer, 0, encodingLength);
    }

    private void writeHeaderToBytes() throws IOException {
        ReadWriteIOUtils.write(this.writeIndex, (OutputStream)this.out);
        ReadWriteIOUtils.write(this.writeWidth, (OutputStream)this.out);
        this.writeHeader();
    }

    private void flushBlockBuffer(ByteArrayOutputStream out) throws IOException {
        if (this.writeIndex == -1) {
            return;
        }
        this.out = out;
        for (int i = 0; i < this.writeIndex; ++i) {
            this.calcTwoDiff(i);
        }
        this.writeWidth = this.calculateBitWidthsForDeltaBlockBuffer();
        this.writeHeaderToBytes();
        this.writeDataWithMinWidth();
        this.reset();
        this.writeIndex = -1;
    }

    @Override
    public void flush(ByteArrayOutputStream out) {
        try {
            this.flushBlockBuffer(out);
        }
        catch (IOException e) {
            logger.error("flush data to stream failed!", e);
        }
    }

    public static class LongDeltaEncoder
    extends DeltaBinaryEncoder {
        private long[] deltaBlockBuffer;
        private long firstValue;
        private long previousValue;
        private long minDeltaBase;

        public LongDeltaEncoder() {
            this(128);
        }

        public LongDeltaEncoder(int size) {
            super(size);
            this.deltaBlockBuffer = new long[this.blockSize];
            this.encodingBlockBuffer = new byte[this.blockSize * 8];
            this.reset();
        }

        private void calcDelta(long value) {
            long delta = value - this.previousValue;
            if (delta < this.minDeltaBase) {
                this.minDeltaBase = delta;
            }
            this.deltaBlockBuffer[this.writeIndex++] = delta;
        }

        @Override
        protected void reset() {
            this.firstValue = 0L;
            this.previousValue = 0L;
            this.minDeltaBase = Long.MAX_VALUE;
        }

        private int getValueWidth(long v) {
            return 64 - Long.numberOfLeadingZeros(v);
        }

        @Override
        protected void writeValueToBytes(int i) {
            BytesUtils.longToBytes(this.deltaBlockBuffer[i], this.encodingBlockBuffer, this.writeWidth * i, this.writeWidth);
        }

        @Override
        protected void calcTwoDiff(int i) {
            this.deltaBlockBuffer[i] = this.deltaBlockBuffer[i] - this.minDeltaBase;
        }

        @Override
        protected void writeHeader() throws IOException {
            this.out.write(BytesUtils.longToBytes(this.minDeltaBase));
            this.out.write(BytesUtils.longToBytes(this.firstValue));
        }

        @Override
        public void encode(long value, ByteArrayOutputStream out) {
            this.encodeValue(value, out);
        }

        @Override
        public int getOneItemMaxSize() {
            return 8;
        }

        @Override
        public long getMaxByteSize() {
            return 24L + (long)(this.writeIndex * 8);
        }

        public void encodeValue(long value, ByteArrayOutputStream out) {
            if (this.writeIndex == -1) {
                ++this.writeIndex;
                this.previousValue = this.firstValue = value;
                return;
            }
            this.calcDelta(value);
            this.previousValue = value;
            if (this.writeIndex == this.blockSize) {
                this.flush(out);
            }
        }

        @Override
        protected int calculateBitWidthsForDeltaBlockBuffer() {
            int width = 0;
            for (int i = 0; i < this.writeIndex; ++i) {
                width = Math.max(width, this.getValueWidth(this.deltaBlockBuffer[i]));
            }
            return width;
        }
    }

    public static class IntDeltaEncoder
    extends DeltaBinaryEncoder {
        private int[] deltaBlockBuffer;
        private int firstValue;
        private int previousValue;
        private int minDeltaBase;

        public IntDeltaEncoder() {
            this(128);
        }

        public IntDeltaEncoder(int size) {
            super(size);
            this.deltaBlockBuffer = new int[this.blockSize];
            this.encodingBlockBuffer = new byte[this.blockSize * 4];
            this.reset();
        }

        @Override
        protected int calculateBitWidthsForDeltaBlockBuffer() {
            int width = 0;
            for (int i = 0; i < this.writeIndex; ++i) {
                width = Math.max(width, this.getValueWidth(this.deltaBlockBuffer[i]));
            }
            return width;
        }

        private void calcDelta(int value) {
            int delta = value - this.previousValue;
            if (delta < this.minDeltaBase) {
                this.minDeltaBase = delta;
            }
            this.deltaBlockBuffer[this.writeIndex++] = delta;
        }

        public void encodeValue(int value, ByteArrayOutputStream out) {
            if (this.writeIndex == -1) {
                ++this.writeIndex;
                this.previousValue = this.firstValue = value;
                return;
            }
            this.calcDelta(value);
            this.previousValue = value;
            if (this.writeIndex == this.blockSize) {
                this.flush(out);
            }
        }

        @Override
        protected void reset() {
            this.firstValue = 0;
            this.previousValue = 0;
            this.minDeltaBase = Integer.MAX_VALUE;
        }

        private int getValueWidth(int v) {
            return 32 - Integer.numberOfLeadingZeros(v);
        }

        @Override
        protected void writeValueToBytes(int i) {
            BytesUtils.intToBytes(this.deltaBlockBuffer[i], this.encodingBlockBuffer, this.writeWidth * i, this.writeWidth);
        }

        @Override
        protected void calcTwoDiff(int i) {
            this.deltaBlockBuffer[i] = this.deltaBlockBuffer[i] - this.minDeltaBase;
        }

        @Override
        protected void writeHeader() throws IOException {
            ReadWriteIOUtils.write(this.minDeltaBase, (OutputStream)this.out);
            ReadWriteIOUtils.write(this.firstValue, (OutputStream)this.out);
        }

        @Override
        public void encode(int value, ByteArrayOutputStream out) {
            this.encodeValue(value, out);
        }

        @Override
        public int getOneItemMaxSize() {
            return 4;
        }

        @Override
        public long getMaxByteSize() {
            return 24L + (long)(this.writeIndex * 4);
        }
    }
}

