/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.tsfile.encoding.encoder;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Vector;
import shaded.org.apache.tsfile.encoding.bitpacking.IntPacker;
import shaded.org.apache.tsfile.encoding.encoder.SinglePrecisionEncoderV2;
import shaded.org.apache.tsfile.encoding.encoder.SprintzEncoder;
import shaded.org.apache.tsfile.encoding.fire.IntFire;
import shaded.org.apache.tsfile.exception.encoding.TsFileEncodingException;
import shaded.org.apache.tsfile.utils.ReadWriteForEncodingUtils;

public class FloatSprintzEncoder
extends SprintzEncoder {
    IntPacker packer;
    IntFire firePred;
    protected Vector<Float> values = new Vector();
    int[] convertBuffer;

    public FloatSprintzEncoder() {
        this.firePred = new IntFire(2);
        this.convertBuffer = new int[this.Block_size];
    }

    @Override
    protected void reset() {
        super.reset();
        this.values.clear();
    }

    @Override
    public int getOneItemMaxSize() {
        return 1 + (1 + this.Block_size) * 4;
    }

    @Override
    public long getMaxByteSize() {
        return 1L + (long)(this.values.size() + 1) * 4L;
    }

    protected int predict(Float value, Float preVlaue) throws TsFileEncodingException {
        int pred;
        if (this.predictMethod.equals("delta")) {
            pred = this.delta(value, preVlaue);
        } else if (this.predictMethod.equals("fire")) {
            pred = this.fire(value, preVlaue);
        } else {
            throw new TsFileEncodingException("Config: Predict Method {} of SprintzEncoder is not supported.");
        }
        pred = pred <= 0 ? -2 * pred : 2 * pred - 1;
        return pred;
    }

    @Override
    protected void bitPack() throws IOException {
        float preValue = this.values.get(0).floatValue();
        this.values.remove(0);
        Vector<Integer> convertBufferList = new Vector<Integer>();
        for (int itemBuffer : this.convertBuffer) {
            convertBufferList.add(itemBuffer);
        }
        this.bitWidth = ReadWriteForEncodingUtils.getIntMaxBitWidth(convertBufferList);
        this.packer = new IntPacker(this.bitWidth);
        byte[] bytes = new byte[this.bitWidth];
        this.packer.pack8Values(this.convertBuffer, 0, bytes);
        ReadWriteForEncodingUtils.writeIntLittleEndianPaddedOnBitWidth(this.bitWidth, this.byteCache, 1);
        this.byteCache.write(ByteBuffer.allocate(4).putFloat(preValue).array());
        this.byteCache.write(bytes, 0, bytes.length);
    }

    protected int delta(Float value, Float preValue) {
        return Float.floatToIntBits(value.floatValue()) - Float.floatToIntBits(preValue.floatValue());
    }

    protected int fire(Float value, Float preValue) {
        int prev = Float.floatToIntBits(preValue.floatValue());
        int val = Float.floatToIntBits(value.floatValue());
        int pred = this.firePred.predict(prev);
        int err = val - pred;
        this.firePred.train(prev, val, err);
        return err;
    }

    @Override
    public void flush(ByteArrayOutputStream out) throws IOException {
        if (this.byteCache.size() > 0) {
            this.byteCache.writeTo(out);
        }
        if (!this.values.isEmpty()) {
            int size = this.values.size();
            ReadWriteForEncodingUtils.writeIntLittleEndianPaddedOnBitWidth(size |= 0x80, out, 1);
            SinglePrecisionEncoderV2 encoder = new SinglePrecisionEncoderV2();
            for (float val : this.values) {
                encoder.encode(val, out);
            }
            encoder.flush(out);
        }
        this.reset();
    }

    @Override
    public void encode(float value, ByteArrayOutputStream out) {
        if (!this.isFirstCached) {
            this.values.add(Float.valueOf(value));
            this.isFirstCached = true;
            return;
        }
        this.values.add(Float.valueOf(value));
        if (this.values.size() == this.Block_size + 1) {
            try {
                this.firePred.reset();
                for (int i = 1; i <= this.Block_size; ++i) {
                    this.convertBuffer[i - 1] = this.predict(this.values.get(i), this.values.get(i - 1));
                }
                this.bitPack();
                this.isFirstCached = false;
                this.values.clear();
                ++this.groupNum;
                if (this.groupNum == this.groupMax) {
                    this.flush(out);
                }
            }
            catch (IOException e) {
                logger.error("Error occured when encoding Float Type value with with Sprintz", e);
            }
        }
    }
}

