/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.tsfile.encoding.encoder;

import java.io.ByteArrayOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import shaded.org.apache.tsfile.encoding.encoder.RLBE;

public class IntRLBE
extends RLBE {
    private final int[] diffValue;
    private final int[] lengRLE;
    private int previousValue;
    private static final Logger logger = LoggerFactory.getLogger(IntRLBE.class);

    public IntRLBE() {
        this.diffValue = new int[this.blockSize + 1];
        this.lengRLE = new int[this.blockSize + 1];
        this.reset();
    }

    protected void reset() {
        this.writeIndex = -1;
        this.LengthCode = new int[this.blockSize + 1];
        for (int i = 0; i < this.blockSize; ++i) {
            this.diffValue[i] = 0;
            this.LengthCode[i] = 0;
            this.byteBuffer = 0;
            this.numberLeftInBuffer = 0;
            this.lengRLE[i] = 0;
        }
    }

    private int calBinarylength(int val) {
        int i;
        if (val == 0) {
            return 1;
        }
        for (i = 32; (1 << i - 1 & val) == 0 && i > 0; --i) {
        }
        return i;
    }

    public void encodeValue(int value, ByteArrayOutputStream out) {
        if (this.writeIndex == -1) {
            this.diffValue[++this.writeIndex] = value;
            this.LengthCode[this.writeIndex] = this.calBinarylength(value);
            this.previousValue = value;
            return;
        }
        this.diffValue[++this.writeIndex] = value - this.previousValue;
        this.LengthCode[this.writeIndex] = this.calBinarylength(this.diffValue[this.writeIndex]);
        this.previousValue = value;
        if (this.writeIndex == this.blockSize - 1) {
            this.flush(out);
        }
    }

    @Override
    public void encode(int value, ByteArrayOutputStream out) {
        this.encodeValue(value, out);
    }

    @Override
    public void flush(ByteArrayOutputStream out) {
        this.flushBlock(out);
    }

    protected int calcFibonacci(int val) {
        int[] fib = new int[this.blockSize * 2 + 1];
        fib[0] = 1;
        fib[1] = 1;
        int i = 2;
        while (fib[i - 1] <= val) {
            fib[i] = fib[i - 1] + fib[i - 2];
            ++i;
        }
        --i;
        int valfib = 0;
        while (val > 0) {
            while (fib[i] > val && i >= 1) {
                --i;
            }
            valfib |= 1 << i - 1;
            val -= fib[i];
        }
        return valfib;
    }

    private void rleonlengthcode() {
        int i = 0;
        while (i <= this.writeIndex) {
            int j = i;
            int temprlecal = 0;
            while (this.LengthCode[j] == this.LengthCode[i] && j <= this.writeIndex) {
                ++j;
                ++temprlecal;
            }
            this.lengRLE[i] = temprlecal;
            i = j;
        }
    }

    protected void flushBlock(ByteArrayOutputStream out) {
        if (this.writeIndex == -1) {
            return;
        }
        this.writewriteIndex(out);
        this.rleonlengthcode();
        for (int i = 0; i <= this.writeIndex; ++i) {
            if (this.lengRLE[i] <= 0) continue;
            this.flushSegment(i, out);
        }
        this.clearBuffer(out);
        this.reset();
    }

    private void flushSegment(int i, ByteArrayOutputStream out) {
        int j;
        for (int j2 = 5; j2 >= 0; --j2) {
            if ((this.LengthCode[i] & 1 << j2) > 0) {
                this.writeBit(true, out);
                continue;
            }
            this.writeBit(false, out);
        }
        int fib = this.calcFibonacci(this.lengRLE[i]);
        int fiblen = this.calBinarylength(fib);
        for (j = 0; j < fiblen; ++j) {
            if ((fib & 1 << j) > 0) {
                this.writeBit(true, out);
                continue;
            }
            this.writeBit(false, out);
        }
        this.writeBit(true, out);
        j = i;
        do {
            int tempDifflen = this.calBinarylength(this.diffValue[j]);
            for (int k = tempDifflen - 1; k >= 0; --k) {
                if ((this.diffValue[j] & 1 << k) > 0) {
                    this.writeBit(true, out);
                    continue;
                }
                this.writeBit(false, out);
            }
        } while (this.lengRLE[++j] == 0 && j <= this.writeIndex);
    }

    @Override
    public int getOneItemMaxSize() {
        return 16;
    }

    @Override
    public long getMaxByteSize() {
        return 20L * (long)this.blockSize;
    }

    protected void writeBit(boolean b, ByteArrayOutputStream out) {
        this.byteBuffer = (byte)(this.byteBuffer << 1);
        if (b) {
            this.byteBuffer = (byte)(this.byteBuffer | 1);
        }
        ++this.numberLeftInBuffer;
        if (this.numberLeftInBuffer == 8) {
            this.clearBuffer(out);
        }
    }

    protected void clearBuffer(ByteArrayOutputStream out) {
        if (this.numberLeftInBuffer == 0) {
            return;
        }
        if (this.numberLeftInBuffer > 0) {
            this.byteBuffer = (byte)(this.byteBuffer << 8 - this.numberLeftInBuffer);
        }
        out.write(this.byteBuffer);
        this.numberLeftInBuffer = 0;
        this.byteBuffer = 0;
    }

    private void writewriteIndex(ByteArrayOutputStream out) {
        for (int i = 31; i >= 0; --i) {
            if ((this.writeIndex + 1 & 1 << i) > 0) {
                this.writeBit(true, out);
                continue;
            }
            this.writeBit(false, out);
        }
    }
}

