/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.tsfile.encoding.encoder;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import shaded.org.apache.tsfile.encoding.encoder.Encoder;
import shaded.org.apache.tsfile.file.metadata.enums.TSEncoding;
import shaded.org.apache.tsfile.utils.ReadWriteForEncodingUtils;

public class IntZigzagEncoder
extends Encoder {
    private static final Logger logger = LoggerFactory.getLogger(IntZigzagEncoder.class);
    private List<Integer> values;
    byte[] buf = new byte[5];

    public IntZigzagEncoder() {
        super(TSEncoding.ZIGZAG);
        this.values = new ArrayList<Integer>();
        logger.debug("tsfile-encoding IntZigzagEncoder: int zigzag encoder");
    }

    private byte[] encodeInt(int n) {
        n = n << 1 ^ n >> 31;
        int idx = 0;
        if ((n & 0xFFFFFF80) != 0) {
            this.buf[idx++] = (byte)((n | 0x80) & 0xFF);
            n >>>= 7;
            while (n > 127) {
                this.buf[idx++] = (byte)((n | 0x80) & 0xFF);
                n >>>= 7;
            }
        }
        this.buf[idx++] = (byte)n;
        return Arrays.copyOfRange(this.buf, 0, idx);
    }

    @Override
    public void encode(int value, ByteArrayOutputStream out) {
        this.values.add(value);
    }

    @Override
    public void flush(ByteArrayOutputStream out) throws IOException {
        ByteArrayOutputStream byteCache = new ByteArrayOutputStream();
        int len = this.values.size();
        if (this.values.size() == 0) {
            return;
        }
        for (int value : this.values) {
            byte[] bytes = this.encodeInt(value);
            byteCache.write(bytes, 0, bytes.length);
        }
        ReadWriteForEncodingUtils.writeUnsignedVarInt(byteCache.size(), out);
        ReadWriteForEncodingUtils.writeUnsignedVarInt(len, out);
        out.write(byteCache.toByteArray());
        this.reset();
    }

    private void reset() {
        this.values.clear();
    }

    @Override
    public long getMaxByteSize() {
        if (this.values == null) {
            return 0L;
        }
        return 8L + (long)(this.values.size() * 4);
    }
}

