/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.tsfile.encoding.encoder;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import shaded.org.apache.tsfile.common.conf.TSFileConfig;
import shaded.org.apache.tsfile.common.conf.TSFileDescriptor;
import shaded.org.apache.tsfile.encoding.encoder.Encoder;
import shaded.org.apache.tsfile.exception.encoding.TsFileEncodingException;
import shaded.org.apache.tsfile.file.metadata.enums.TSEncoding;
import shaded.org.apache.tsfile.utils.Binary;
import shaded.org.apache.tsfile.utils.ReadWriteForEncodingUtils;

public abstract class RleEncoder<T extends Comparable<T>>
extends Encoder {
    private static final Logger logger = LoggerFactory.getLogger(RleEncoder.class);
    protected List<T> values;
    protected int bitWidth;
    protected int repeatCount;
    protected int bitPackedGroupCount;
    protected int numBufferedValues;
    protected List<byte[]> bytesBuffer;
    protected boolean isBitPackRun = false;
    protected T preValue;
    protected T[] bufferedValues;
    protected boolean isBitWidthSaved = false;
    protected ByteArrayOutputStream byteCache;
    protected TSFileConfig config = TSFileDescriptor.getInstance().getConfig();

    protected RleEncoder() {
        super(TSEncoding.RLE);
        this.bytesBuffer = new ArrayList<byte[]>();
        this.byteCache = new ByteArrayOutputStream();
    }

    protected void reset() {
        this.numBufferedValues = 0;
        this.repeatCount = 0;
        this.bitPackedGroupCount = 0;
        this.bytesBuffer.clear();
        this.isBitPackRun = false;
        this.isBitWidthSaved = false;
        this.byteCache.reset();
        this.values.clear();
    }

    @Override
    public void flush(ByteArrayOutputStream out) throws IOException {
        int lastBitPackedNum = this.numBufferedValues;
        if (this.repeatCount >= 8) {
            try {
                this.writeRleRun();
            }
            catch (IOException e) {
                logger.error("tsfile-encoding RleEncoder : error occurs when writing nums to OutputStram when flushing left nums. numBufferedValues {}, repeatCount {}, bitPackedGroupCount{}, isBitPackRun {}, isBitWidthSaved {}", this.numBufferedValues, this.repeatCount, this.bitPackedGroupCount, this.isBitPackRun, this.isBitWidthSaved, e);
                throw e;
            }
        } else if (this.numBufferedValues > 0) {
            this.clearBuffer();
            this.writeOrAppendBitPackedRun();
            this.endPreviousBitPackedRun(lastBitPackedNum);
        } else {
            this.endPreviousBitPackedRun(8);
        }
        ReadWriteForEncodingUtils.writeUnsignedVarInt(this.byteCache.size(), out);
        this.byteCache.writeTo(out);
        this.reset();
    }

    protected abstract void writeRleRun() throws IOException;

    public void writeOrAppendBitPackedRun() {
        if (this.bitPackedGroupCount >= 63) {
            this.endPreviousBitPackedRun(8);
        }
        if (!this.isBitPackRun) {
            this.isBitPackRun = true;
        }
        this.convertBuffer();
        this.numBufferedValues = 0;
        this.repeatCount = 0;
        ++this.bitPackedGroupCount;
    }

    protected void endPreviousBitPackedRun(int lastBitPackedNum) {
        if (!this.isBitPackRun) {
            return;
        }
        byte bitPackHeader = (byte)(this.bitPackedGroupCount << 1 | 1);
        this.byteCache.write(bitPackHeader);
        this.byteCache.write(lastBitPackedNum);
        for (byte[] bytes : this.bytesBuffer) {
            this.byteCache.write(bytes, 0, bytes.length);
        }
        this.bytesBuffer.clear();
        this.isBitPackRun = false;
        this.bitPackedGroupCount = 0;
    }

    protected void encodeValue(T value) {
        if (!this.isBitWidthSaved) {
            this.byteCache.write(this.bitWidth);
            this.isBitWidthSaved = true;
        }
        if (value.equals(this.preValue)) {
            ++this.repeatCount;
            if (this.repeatCount >= 8 && this.repeatCount <= Short.MAX_VALUE) {
                return;
            }
            if (this.repeatCount == 32768) {
                this.repeatCount = Short.MAX_VALUE;
                try {
                    this.writeRleRun();
                    logger.debug("tsfile-encoding RleEncoder : write full rle run to stream");
                }
                catch (IOException e) {
                    logger.error(" error occurs when writing full rle run to OutputStram when repeatCount = {}.numBufferedValues {}, repeatCount {}, bitPackedGroupCount{}, isBitPackRun {}, isBitWidthSaved {}", 32768, this.numBufferedValues, this.repeatCount, this.bitPackedGroupCount, this.isBitPackRun, this.isBitWidthSaved, e);
                }
                this.repeatCount = 1;
                this.preValue = value;
            }
        } else {
            if (this.repeatCount >= 8) {
                try {
                    this.writeRleRun();
                }
                catch (IOException e) {
                    logger.error("tsfile-encoding RleEncoder : error occurs when writing num to OutputStram when repeatCount > {}.numBufferedValues {}, repeatCount {}, bitPackedGroupCount{}, isBitPackRun {}, isBitWidthSaved {}", 8, this.numBufferedValues, this.repeatCount, this.bitPackedGroupCount, this.isBitPackRun, this.isBitWidthSaved, e);
                }
            }
            this.repeatCount = 1;
            this.preValue = value;
        }
        this.bufferedValues[this.numBufferedValues] = value;
        ++this.numBufferedValues;
        if (this.numBufferedValues == 8) {
            this.writeOrAppendBitPackedRun();
        }
    }

    protected abstract void clearBuffer();

    protected abstract void convertBuffer();

    @Override
    public void encode(boolean value, ByteArrayOutputStream out) {
        throw new TsFileEncodingException(this.getClass().getName());
    }

    @Override
    public void encode(short value, ByteArrayOutputStream out) {
        throw new TsFileEncodingException(this.getClass().getName());
    }

    @Override
    public void encode(int value, ByteArrayOutputStream out) {
        throw new TsFileEncodingException(this.getClass().getName());
    }

    @Override
    public void encode(long value, ByteArrayOutputStream out) {
        throw new TsFileEncodingException(this.getClass().getName());
    }

    @Override
    public void encode(float value, ByteArrayOutputStream out) {
        throw new TsFileEncodingException(this.getClass().getName());
    }

    @Override
    public void encode(double value, ByteArrayOutputStream out) {
        throw new TsFileEncodingException(this.getClass().getName());
    }

    @Override
    public void encode(Binary value, ByteArrayOutputStream out) {
        throw new TsFileEncodingException(this.getClass().getName());
    }

    @Override
    public void encode(BigDecimal value, ByteArrayOutputStream out) {
        throw new TsFileEncodingException(this.getClass().getName());
    }
}

