/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.tsfile.encoding.encoder;

public class SDTEncoder {
    private long lastReadTimestamp;
    private long lastReadLong;
    private double lastReadDouble;
    private int lastReadInt;
    private float lastReadFloat;
    private long lastStoredTimestamp;
    private long lastStoredLong;
    private double lastStoredDouble;
    private int lastStoredInt;
    private float lastStoredFloat;
    private double upperDoor = -2.147483648E9;
    private double lowerDoor = 2.147483647E9;
    private double compDeviation = -1.0;
    private long compMinTime = 0L;
    private long compMaxTime = Long.MAX_VALUE;
    private boolean isFirstValue = true;

    public boolean encodeFloat(long time, float value) {
        double curLowerSlope;
        if (this.isFirstValue(time, value)) {
            return true;
        }
        if (time - this.lastStoredTimestamp <= this.compMinTime) {
            return false;
        }
        if (time - this.lastStoredTimestamp >= this.compMaxTime) {
            this.reset(time, value);
            return true;
        }
        double curUpperSlope = ((double)(value - this.lastStoredFloat) - this.compDeviation) / (double)(time - this.lastStoredTimestamp);
        if (curUpperSlope > this.upperDoor) {
            this.upperDoor = curUpperSlope;
        }
        if ((curLowerSlope = ((double)(value - this.lastStoredFloat) + this.compDeviation) / (double)(time - this.lastStoredTimestamp)) < this.lowerDoor) {
            this.lowerDoor = curLowerSlope;
        }
        if (this.upperDoor >= this.lowerDoor) {
            this.lastStoredTimestamp = this.lastReadTimestamp;
            this.lastStoredFloat = this.lastReadFloat;
            this.upperDoor = ((double)(value - this.lastStoredFloat) - this.compDeviation) / (double)(time - this.lastStoredTimestamp);
            this.lowerDoor = ((double)(value - this.lastStoredFloat) + this.compDeviation) / (double)(time - this.lastStoredTimestamp);
            this.lastReadFloat = value;
            this.lastReadTimestamp = time;
            return true;
        }
        this.lastReadFloat = value;
        this.lastReadTimestamp = time;
        return false;
    }

    public boolean encodeLong(long time, long value) {
        double curLowerSlope;
        if (this.isFirstValue(time, value)) {
            return true;
        }
        if (time - this.lastStoredTimestamp <= this.compMinTime) {
            return false;
        }
        if (time - this.lastStoredTimestamp >= this.compMaxTime) {
            this.reset(time, value);
            return true;
        }
        double curUpperSlope = ((double)(value - this.lastStoredLong) - this.compDeviation) / (double)(time - this.lastStoredTimestamp);
        if (curUpperSlope > this.upperDoor) {
            this.upperDoor = curUpperSlope;
        }
        if ((curLowerSlope = ((double)(value - this.lastStoredLong) + this.compDeviation) / (double)(time - this.lastStoredTimestamp)) < this.lowerDoor) {
            this.lowerDoor = curLowerSlope;
        }
        if (this.upperDoor >= this.lowerDoor) {
            this.lastStoredLong = this.lastReadLong;
            this.lastStoredTimestamp = this.lastReadTimestamp;
            this.upperDoor = ((double)(value - this.lastStoredLong) - this.compDeviation) / (double)(time - this.lastStoredTimestamp);
            this.lowerDoor = ((double)(value - this.lastStoredLong) + this.compDeviation) / (double)(time - this.lastStoredTimestamp);
            this.lastReadLong = value;
            this.lastReadTimestamp = time;
            return true;
        }
        this.lastReadLong = value;
        this.lastReadTimestamp = time;
        return false;
    }

    public boolean encodeInt(long time, int value) {
        double curLowerSlope;
        if (this.isFirstValue(time, value)) {
            return true;
        }
        if (time - this.lastStoredTimestamp <= this.compMinTime) {
            return false;
        }
        if (time - this.lastStoredTimestamp >= this.compMaxTime) {
            this.reset(time, value);
            return true;
        }
        double curUpperSlope = ((double)(value - this.lastStoredInt) - this.compDeviation) / (double)(time - this.lastStoredTimestamp);
        if (curUpperSlope > this.upperDoor) {
            this.upperDoor = curUpperSlope;
        }
        if ((curLowerSlope = ((double)(value - this.lastStoredInt) + this.compDeviation) / (double)(time - this.lastStoredTimestamp)) < this.lowerDoor) {
            this.lowerDoor = curLowerSlope;
        }
        if (this.upperDoor >= this.lowerDoor) {
            this.lastStoredTimestamp = this.lastReadTimestamp;
            this.lastStoredInt = this.lastReadInt;
            this.upperDoor = ((double)(value - this.lastStoredInt) - this.compDeviation) / (double)(time - this.lastStoredTimestamp);
            this.lowerDoor = ((double)(value - this.lastStoredInt) + this.compDeviation) / (double)(time - this.lastStoredTimestamp);
            this.lastReadInt = value;
            this.lastReadTimestamp = time;
            return true;
        }
        this.lastReadInt = value;
        this.lastReadTimestamp = time;
        return false;
    }

    public boolean encodeDouble(long time, double value) {
        double curLowerSlope;
        if (this.isFirstValue(time, value)) {
            return true;
        }
        if (time - this.lastStoredTimestamp <= this.compMinTime) {
            return false;
        }
        if (time - this.lastStoredTimestamp >= this.compMaxTime) {
            this.reset(time, value);
            return true;
        }
        double curUpperSlope = (value - this.lastStoredDouble - this.compDeviation) / (double)(time - this.lastStoredTimestamp);
        if (curUpperSlope > this.upperDoor) {
            this.upperDoor = curUpperSlope;
        }
        if ((curLowerSlope = (value - this.lastStoredDouble + this.compDeviation) / (double)(time - this.lastStoredTimestamp)) < this.lowerDoor) {
            this.lowerDoor = curLowerSlope;
        }
        if (this.upperDoor >= this.lowerDoor) {
            this.lastStoredTimestamp = this.lastReadTimestamp;
            this.lastStoredDouble = this.lastReadDouble;
            this.upperDoor = (value - this.lastStoredDouble - this.compDeviation) / (double)(time - this.lastStoredTimestamp);
            this.lowerDoor = (value - this.lastStoredDouble + this.compDeviation) / (double)(time - this.lastStoredTimestamp);
            this.lastReadDouble = value;
            this.lastReadTimestamp = time;
            return true;
        }
        this.lastReadDouble = value;
        this.lastReadTimestamp = time;
        return false;
    }

    public int encode(long[] timestamps, double[] values, int batchSize) {
        int index = 0;
        for (int i = 0; i < batchSize; ++i) {
            if (!this.encodeDouble(timestamps[i], values[i])) continue;
            timestamps[index] = this.lastStoredTimestamp;
            values[index] = this.lastStoredDouble;
            ++index;
        }
        return index;
    }

    public int encode(long[] timestamps, int[] values, int batchSize) {
        int index = 0;
        for (int i = 0; i < batchSize; ++i) {
            if (!this.encodeInt(timestamps[i], values[i])) continue;
            timestamps[index] = this.lastStoredTimestamp;
            values[index] = this.lastStoredInt;
            ++index;
        }
        return index;
    }

    public int encode(long[] timestamps, long[] values, int batchSize) {
        int index = 0;
        for (int i = 0; i < batchSize; ++i) {
            if (!this.encodeLong(timestamps[i], values[i])) continue;
            timestamps[index] = this.lastStoredTimestamp;
            values[index] = this.lastStoredLong;
            ++index;
        }
        return index;
    }

    public int encode(long[] timestamps, float[] values, int batchSize) {
        int index = 0;
        for (int i = 0; i < batchSize; ++i) {
            if (!this.encodeFloat(timestamps[i], values[i])) continue;
            timestamps[index] = this.lastStoredTimestamp;
            values[index] = this.lastStoredFloat;
            ++index;
        }
        return index;
    }

    private boolean isFirstValue(long time, float value) {
        if (this.isFirstValue) {
            this.isFirstValue = false;
            this.lastReadTimestamp = time;
            this.lastReadFloat = value;
            this.lastStoredTimestamp = time;
            this.lastStoredFloat = value;
            return true;
        }
        return false;
    }

    private boolean isFirstValue(long time, long value) {
        if (this.isFirstValue) {
            this.isFirstValue = false;
            this.lastReadTimestamp = time;
            this.lastReadLong = value;
            this.lastStoredTimestamp = time;
            this.lastStoredLong = value;
            return true;
        }
        return false;
    }

    private boolean isFirstValue(long time, int value) {
        if (this.isFirstValue) {
            this.isFirstValue = false;
            this.lastReadTimestamp = time;
            this.lastReadInt = value;
            this.lastStoredTimestamp = time;
            this.lastStoredInt = value;
            return true;
        }
        return false;
    }

    private boolean isFirstValue(long time, double value) {
        if (this.isFirstValue) {
            this.isFirstValue = false;
            this.lastReadTimestamp = time;
            this.lastReadDouble = value;
            this.lastStoredTimestamp = time;
            this.lastStoredDouble = value;
            return true;
        }
        return false;
    }

    private void reset() {
        this.upperDoor = -2.147483648E9;
        this.lowerDoor = 2.147483647E9;
    }

    private void reset(long time, long value) {
        this.reset();
        this.lastStoredTimestamp = time;
        this.lastStoredLong = value;
    }

    private void reset(long time, double value) {
        this.reset();
        this.lastStoredTimestamp = time;
        this.lastStoredDouble = value;
    }

    private void reset(long time, int value) {
        this.reset();
        this.lastStoredTimestamp = time;
        this.lastStoredInt = value;
    }

    private void reset(long time, float value) {
        this.reset();
        this.lastStoredTimestamp = time;
        this.lastStoredFloat = value;
    }

    public void setCompDeviation(double compDeviation) {
        this.compDeviation = compDeviation;
    }

    public double getCompDeviation() {
        return this.compDeviation;
    }

    public void setCompMinTime(long compMinTime) {
        this.compMinTime = compMinTime;
    }

    public long getCompMinTime() {
        return this.compMinTime;
    }

    public void setCompMaxTime(long compMaxTime) {
        this.compMaxTime = compMaxTime;
    }

    public long getCompMaxTime() {
        return this.compMaxTime;
    }

    public long getTime() {
        return this.lastStoredTimestamp;
    }

    public int getIntValue() {
        return this.lastStoredInt;
    }

    public double getDoubleValue() {
        return this.lastStoredDouble;
    }

    public long getLongValue() {
        return this.lastStoredLong;
    }

    public float getFloatValue() {
        return this.lastStoredFloat;
    }
}

