/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.tsfile.encrypt;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import shaded.org.apache.tsfile.encrypt.EncryptParameter;
import shaded.org.apache.tsfile.encrypt.EncryptUtils;
import shaded.org.apache.tsfile.encrypt.IEncrypt;
import shaded.org.apache.tsfile.exception.encrypt.EncryptException;
import shaded.org.apache.tsfile.file.metadata.enums.EncryptionType;

public interface IEncryptor {
    public static final Logger logger = LoggerFactory.getLogger(IEncryptor.class);

    public static IEncryptor getEncryptor(String type, byte[] key) {
        try {
            String className = EncryptUtils.getEncryptClass(type);
            if (IEncrypt.encryptMap.containsKey(className)) {
                return ((IEncrypt)IEncrypt.encryptMap.get(className).newInstance(new Object[]{key})).getEncryptor();
            }
            Class<?> encryptClass = Class.forName(className);
            Constructor<?> constructor = encryptClass.getDeclaredConstructor(byte[].class);
            IEncrypt.encryptMap.put(className, constructor);
            return ((IEncrypt)constructor.newInstance(new Object[]{key})).getEncryptor();
        }
        catch (ClassNotFoundException e) {
            throw new EncryptException("Get encryptor class failed, class not found: " + type, e);
        }
        catch (NoSuchMethodException e) {
            throw new EncryptException("Get constructor for encryptor failed: " + type, e);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new EncryptException("New encryptor instance failed: " + type, e);
        }
    }

    public static IEncryptor getEncryptor(EncryptParameter encryptParam) {
        String type = encryptParam.getType();
        byte[] key = encryptParam.getKey();
        return IEncryptor.getEncryptor(type, key);
    }

    public byte[] encrypt(byte[] var1);

    public byte[] encrypt(byte[] var1, int var2, int var3);

    public EncryptionType getEncryptionType();
}

