/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.tsfile.enums;

import java.io.DataOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import shaded.org.apache.tsfile.write.UnSupportedDataTypeException;

public enum TSDataType {
    BOOLEAN(0),
    INT32(1),
    INT64(2),
    FLOAT(3),
    DOUBLE(4),
    TEXT(5),
    VECTOR(6),
    UNKNOWN(7),
    TIMESTAMP(8),
    DATE(9),
    BLOB(10),
    STRING(11);

    private final byte type;
    private static final Map<TSDataType, Set<TSDataType>> compatibleTypes;

    private TSDataType(byte type) {
        this.type = type;
    }

    public static TSDataType deserialize(byte type) {
        return TSDataType.getTsDataType(type);
    }

    public byte getType() {
        return this.type;
    }

    public static TSDataType getTsDataType(byte type) {
        switch (type) {
            case 0: {
                return BOOLEAN;
            }
            case 1: {
                return INT32;
            }
            case 2: {
                return INT64;
            }
            case 3: {
                return FLOAT;
            }
            case 4: {
                return DOUBLE;
            }
            case 5: {
                return TEXT;
            }
            case 6: {
                return VECTOR;
            }
            case 7: {
                return UNKNOWN;
            }
            case 8: {
                return TIMESTAMP;
            }
            case 9: {
                return DATE;
            }
            case 10: {
                return BLOB;
            }
            case 11: {
                return STRING;
            }
        }
        throw new IllegalArgumentException("Invalid input: " + type);
    }

    public boolean isCompatible(TSDataType source) {
        return this == source || compatibleTypes.getOrDefault((Object)this, Collections.emptySet()).contains((Object)source);
    }

    public Object castFromSingleValue(TSDataType sourceType, Object value) {
        if (Objects.isNull(value)) {
            return null;
        }
        switch (this) {
            case BOOLEAN: {
                if (sourceType != BOOLEAN) break;
                return value;
            }
            case INT32: {
                if (sourceType != INT32) break;
                return value;
            }
            case INT64: {
                if (sourceType == INT64) {
                    return value;
                }
                if (sourceType == INT32) {
                    return (long)((Integer)value).intValue();
                }
                if (sourceType != TIMESTAMP) break;
                return value;
            }
            case FLOAT: {
                if (sourceType == FLOAT) {
                    return value;
                }
                if (sourceType != INT32) break;
                return Float.valueOf(((Integer)value).intValue());
            }
            case DOUBLE: {
                if (sourceType == DOUBLE) {
                    return value;
                }
                if (sourceType == INT32) {
                    return (double)((Integer)value).intValue();
                }
                if (sourceType == INT64) {
                    return (double)((Long)value).longValue();
                }
                if (sourceType == FLOAT) {
                    return (double)((Float)value).floatValue();
                }
                if (sourceType != TIMESTAMP) break;
                return (double)((Long)value).longValue();
            }
            case TEXT: {
                if (sourceType != TEXT && sourceType != STRING) break;
                return value;
            }
            case TIMESTAMP: {
                if (sourceType == TIMESTAMP) {
                    return value;
                }
                if (sourceType == INT32) {
                    return (long)((Integer)value).intValue();
                }
                if (sourceType != INT64) break;
                return value;
            }
            case DATE: {
                if (sourceType != DATE) break;
                return value;
            }
            case BLOB: {
                if (sourceType != BLOB && sourceType != STRING && sourceType != TEXT) break;
                return value;
            }
            case STRING: {
                if (sourceType != STRING && sourceType != TEXT) break;
                return value;
            }
        }
        throw new ClassCastException(String.format("Unsupported cast: from %s to %s", new Object[]{sourceType, this}));
    }

    public Object castFromArray(TSDataType sourceType, Object array) {
        switch (this) {
            case BOOLEAN: {
                if (sourceType != BOOLEAN) break;
                return array;
            }
            case INT32: {
                if (sourceType != INT32) break;
                return array;
            }
            case INT64: {
                if (sourceType == INT64) {
                    return array;
                }
                if (sourceType == INT32) {
                    return Arrays.stream((int[])array).mapToLong(Long::valueOf).toArray();
                }
                if (sourceType != TIMESTAMP) break;
                return array;
            }
            case FLOAT: {
                if (sourceType == FLOAT) {
                    return array;
                }
                if (sourceType != INT32) break;
                int[] tmp = (int[])array;
                float[] result = new float[tmp.length];
                for (int i = 0; i < tmp.length; ++i) {
                    result[i] = tmp[i];
                }
                return result;
            }
            case DOUBLE: {
                if (sourceType == DOUBLE) {
                    return array;
                }
                if (sourceType == INT32) {
                    return Arrays.stream((int[])array).mapToDouble(Double::valueOf).toArray();
                }
                if (sourceType == INT64) {
                    return Arrays.stream((long[])array).mapToDouble(Double::valueOf).toArray();
                }
                if (sourceType == FLOAT) {
                    float[] tmp = (float[])array;
                    double[] result = new double[tmp.length];
                    for (int i = 0; i < tmp.length; ++i) {
                        result[i] = tmp[i];
                    }
                    return result;
                }
                if (sourceType != TIMESTAMP) break;
                return Arrays.stream((long[])array).mapToDouble(Double::valueOf).toArray();
            }
            case TEXT: {
                if (sourceType != TEXT && sourceType != STRING) break;
                return array;
            }
            case TIMESTAMP: {
                if (sourceType == TIMESTAMP) {
                    return array;
                }
                if (sourceType == INT32) {
                    return Arrays.stream((int[])array).mapToLong(Long::valueOf).toArray();
                }
                if (sourceType != INT64) break;
                return array;
            }
            case DATE: {
                if (sourceType != DATE) break;
                return array;
            }
            case BLOB: {
                if (sourceType != BLOB && sourceType != STRING && sourceType != TEXT) break;
                return array;
            }
            case STRING: {
                if (sourceType != STRING && sourceType != TEXT) break;
                return array;
            }
        }
        throw new ClassCastException(String.format("Unsupported cast: from %s to %s", new Object[]{sourceType, this}));
    }

    public static TSDataType deserializeFrom(ByteBuffer buffer) {
        return TSDataType.deserialize(buffer.get());
    }

    public static TSDataType deserializeFrom(InputStream stream) throws IOException {
        return TSDataType.deserialize((byte)stream.read());
    }

    public static int getSerializedSize() {
        return 1;
    }

    public void serializeTo(ByteBuffer byteBuffer) {
        byteBuffer.put(this.serialize());
    }

    public void serializeTo(DataOutputStream outputStream) throws IOException {
        outputStream.write(this.serialize());
    }

    public void serializeTo(FileOutputStream outputStream) throws IOException {
        outputStream.write(this.serialize());
    }

    public int getDataTypeSize() {
        switch (this) {
            case BOOLEAN: {
                return 1;
            }
            case INT32: 
            case FLOAT: 
            case DATE: {
                return 4;
            }
            case INT64: 
            case DOUBLE: 
            case TEXT: 
            case TIMESTAMP: 
            case BLOB: 
            case STRING: 
            case VECTOR: {
                return 8;
            }
        }
        throw new UnSupportedDataTypeException(this.toString());
    }

    public byte serialize() {
        return this.type;
    }

    public boolean isNumeric() {
        switch (this) {
            case INT32: 
            case INT64: 
            case FLOAT: 
            case DOUBLE: {
                return true;
            }
            case BOOLEAN: 
            case TEXT: 
            case TIMESTAMP: 
            case DATE: 
            case BLOB: 
            case STRING: 
            case VECTOR: {
                return false;
            }
        }
        throw new UnSupportedDataTypeException(this.toString());
    }

    public boolean isComparable() {
        switch (this) {
            case BOOLEAN: 
            case INT32: 
            case INT64: 
            case FLOAT: 
            case DOUBLE: 
            case TEXT: 
            case TIMESTAMP: 
            case DATE: 
            case STRING: {
                return true;
            }
            case BLOB: 
            case VECTOR: {
                return false;
            }
        }
        throw new UnSupportedDataTypeException(this.toString());
    }

    public boolean isBinary() {
        return this == TEXT || this == STRING || this == BLOB;
    }

    static {
        compatibleTypes = new EnumMap<TSDataType, Set<TSDataType>>(TSDataType.class);
        compatibleTypes.put(BOOLEAN, Collections.emptySet());
        compatibleTypes.put(INT32, Collections.emptySet());
        HashSet<TSDataType> i64CompatibleTypes = new HashSet<TSDataType>();
        i64CompatibleTypes.add(INT32);
        i64CompatibleTypes.add(TIMESTAMP);
        compatibleTypes.put(INT64, i64CompatibleTypes);
        HashSet<TSDataType> floatCompatibleTypes = new HashSet<TSDataType>();
        floatCompatibleTypes.add(INT32);
        compatibleTypes.put(FLOAT, floatCompatibleTypes);
        HashSet<TSDataType> doubleCompatibleTypes = new HashSet<TSDataType>();
        doubleCompatibleTypes.add(INT32);
        doubleCompatibleTypes.add(INT64);
        doubleCompatibleTypes.add(FLOAT);
        doubleCompatibleTypes.add(TIMESTAMP);
        compatibleTypes.put(DOUBLE, doubleCompatibleTypes);
        HashSet<TSDataType> textCompatibleTypes = new HashSet<TSDataType>();
        textCompatibleTypes.add(STRING);
        compatibleTypes.put(TEXT, textCompatibleTypes);
        compatibleTypes.put(VECTOR, Collections.emptySet());
        compatibleTypes.put(UNKNOWN, Collections.emptySet());
        HashSet<TSDataType> timestampCompatibleTypes = new HashSet<TSDataType>();
        timestampCompatibleTypes.add(INT32);
        timestampCompatibleTypes.add(INT64);
        compatibleTypes.put(TIMESTAMP, timestampCompatibleTypes);
        compatibleTypes.put(DATE, Collections.emptySet());
        HashSet<TSDataType> blobCompatibleTypes = new HashSet<TSDataType>();
        blobCompatibleTypes.add(STRING);
        blobCompatibleTypes.add(TEXT);
        compatibleTypes.put(BLOB, blobCompatibleTypes);
        HashSet<TSDataType> stringCompatibleTypes = new HashSet<TSDataType>();
        stringCompatibleTypes.add(TEXT);
        compatibleTypes.put(STRING, stringCompatibleTypes);
    }
}

