/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.tsfile.file.metadata;

import shaded.org.apache.tsfile.annotations.TsFileApi;
import shaded.org.apache.tsfile.enums.ColumnCategory;
import shaded.org.apache.tsfile.enums.TSDataType;
import shaded.org.apache.tsfile.file.metadata.ColumnSchema;

public class ColumnSchemaBuilder {
    private String columnName;
    private TSDataType columnDataType;
    private ColumnCategory columnCategory = ColumnCategory.FIELD;

    @TsFileApi
    public ColumnSchema build() {
        this.validateParameters();
        return new ColumnSchema(this.columnName, this.columnDataType, this.columnCategory);
    }

    @TsFileApi
    public ColumnSchemaBuilder name(String columnName) {
        if (columnName == null || columnName.isEmpty()) {
            throw new IllegalArgumentException("Column name must be a non empty string");
        }
        this.columnName = columnName;
        return this;
    }

    @TsFileApi
    public ColumnSchemaBuilder dataType(TSDataType columnType) {
        this.columnDataType = columnType;
        return this;
    }

    @TsFileApi
    public ColumnSchemaBuilder category(ColumnCategory columnCategory) {
        this.columnCategory = columnCategory;
        return this;
    }

    private void validateParameters() {
        if (this.columnName == null) {
            throw new IllegalStateException("Column name must be set before building");
        }
        if (this.columnDataType == null) {
            throw new IllegalStateException("Column data type must be set before building");
        }
    }
}

