/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.tsfile.file.metadata;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import shaded.org.apache.tsfile.compatibility.DeserializeConfig;
import shaded.org.apache.tsfile.file.IMetadataIndexEntry;
import shaded.org.apache.tsfile.file.metadata.IDeviceID;
import shaded.org.apache.tsfile.utils.ReadWriteIOUtils;

public class DeviceMetadataIndexEntry
implements IMetadataIndexEntry {
    private IDeviceID deviceID;
    private long offset;

    public DeviceMetadataIndexEntry(IDeviceID deviceID, long offset) {
        this.deviceID = deviceID;
        this.offset = offset;
    }

    public IDeviceID getDeviceID() {
        return this.deviceID;
    }

    @Override
    public long getOffset() {
        return this.offset;
    }

    public void setDeviceID(IDeviceID deviceID) {
        this.deviceID = deviceID;
    }

    @Override
    public void setOffset(long offset) {
        this.offset = offset;
    }

    @Override
    public int serializeTo(OutputStream outputStream) throws IOException {
        int byteLen = 0;
        byteLen += this.deviceID.serialize(outputStream);
        return byteLen += ReadWriteIOUtils.write(this.offset, outputStream);
    }

    @Override
    public Comparable getCompareKey() {
        return this.deviceID;
    }

    @Override
    public boolean isDeviceLevel() {
        return true;
    }

    public static DeviceMetadataIndexEntry deserializeFrom(ByteBuffer buffer, DeserializeConfig context) {
        IDeviceID device = context.deviceIDBufferDeserializer.deserialize(buffer, context);
        long offset = ReadWriteIOUtils.readLong(buffer);
        return new DeviceMetadataIndexEntry(device, offset);
    }

    public static DeviceMetadataIndexEntry deserializeFrom(InputStream inputStream, DeserializeConfig config) throws IOException {
        IDeviceID device = config.deviceIDStreamDeserializer.deserialize(inputStream, config);
        long offset = ReadWriteIOUtils.readLong(inputStream);
        return new DeviceMetadataIndexEntry(device, offset);
    }

    @Override
    public int serializedSize() {
        return this.deviceID.serializedSize() + 8;
    }

    public String toString() {
        return "<" + this.deviceID + "," + this.offset + ">";
    }
}

