/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.tsfile.file.metadata;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import shaded.org.apache.tsfile.file.metadata.PlainDeviceID;
import shaded.org.apache.tsfile.file.metadata.StringArrayDeviceID;
import shaded.org.apache.tsfile.utils.Accountable;

public interface IDeviceID
extends Comparable<IDeviceID>,
Accountable,
Serializable {
    public static final Logger LOGGER = LoggerFactory.getLogger(IDeviceID.class);

    public int serialize(ByteBuffer var1);

    public int serialize(OutputStream var1) throws IOException;

    public byte[] getBytes();

    public boolean isEmpty();

    public boolean isTableModel();

    public String getTableName();

    public int segmentNum();

    public Object segment(int var1);

    default public int serializedSize() {
        int n;
        LOGGER.debug("Using default inefficient implementation of serialized size by {}", (Object)this.getClass());
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            this.serialize(baos);
            n = baos.size();
        }
        catch (Throwable throwable) {
            try {
                try {
                    baos.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                LOGGER.error("Failed to serialize device ID: {}", (Object)this, (Object)e);
                return -1;
            }
        }
        baos.close();
        return n;
    }

    default public boolean startWith(String prefix) {
        return this.startWith(prefix, false);
    }

    default public boolean startWith(String prefix, boolean matchEntireSegment) {
        int matchedPos = 0;
        for (int currSegment = 0; currSegment < this.segmentNum(); ++currSegment) {
            String remainingPrefix;
            String segmentString = this.segment(currSegment).toString();
            if (segmentString.startsWith(remainingPrefix = prefix.substring(matchedPos))) {
                if (matchEntireSegment) {
                    return segmentString.equals(remainingPrefix);
                }
                return true;
            }
            if (!remainingPrefix.startsWith(segmentString)) {
                return false;
            }
            if (prefix.charAt(matchedPos += segmentString.length()) != '.') {
                return false;
            }
            ++matchedPos;
        }
        return false;
    }

    default public Object[] getSegments() {
        Object[] segments = new Object[this.segmentNum()];
        for (int i = 0; i < this.segmentNum(); ++i) {
            segments[i] = this.segment(i);
        }
        return segments;
    }

    default public boolean matchDatabaseName(String databaseName) {
        String tableName = this.getTableName();
        if (tableName.startsWith(databaseName) && (tableName.length() == databaseName.length() || tableName.charAt(databaseName.length()) == '.')) {
            return true;
        }
        return this.startWith(databaseName, true);
    }

    public static interface TreeDeviceIdColumnValueExtractor {
        public Object extract(IDeviceID var1, int var2);
    }

    public static interface Factory {
        public static final Factory DEFAULT_FACTORY = StringArrayDeviceID.getFACTORY();

        public IDeviceID create(String var1);

        public IDeviceID create(String[] var1);
    }

    public static interface Deserializer {
        public static final Deserializer DEFAULT_DESERIALIZER = StringArrayDeviceID.getDESERIALIZER();
        public static final Deserializer DESERIALIZER_V3 = PlainDeviceID.getDESERIALIZER();

        public IDeviceID deserializeFrom(ByteBuffer var1);

        public IDeviceID deserializeFrom(InputStream var1) throws IOException;
    }
}

