/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.tsfile.file.metadata;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import shaded.org.apache.tsfile.enums.ColumnCategory;
import shaded.org.apache.tsfile.enums.TSDataType;
import shaded.org.apache.tsfile.file.metadata.ChunkGroupMetadata;
import shaded.org.apache.tsfile.file.metadata.TableSchema;
import shaded.org.apache.tsfile.file.metadata.enums.CompressionType;
import shaded.org.apache.tsfile.file.metadata.enums.TSEncoding;
import shaded.org.apache.tsfile.write.schema.IMeasurementSchema;
import shaded.org.apache.tsfile.write.schema.MeasurementSchema;

public class LogicalTableSchema
extends TableSchema {
    private int maxLevel;

    public LogicalTableSchema(String tableName) {
        super(tableName);
    }

    @Override
    public void update(ChunkGroupMetadata chunkGroupMetadata) {
        super.update(chunkGroupMetadata);
        this.maxLevel = Math.max(this.maxLevel, chunkGroupMetadata.getDevice().segmentNum());
    }

    private List<IMeasurementSchema> generateIdColumns() {
        ArrayList<IMeasurementSchema> generatedIdColumns = new ArrayList<IMeasurementSchema>();
        for (int i = 1; i < this.maxLevel; ++i) {
            generatedIdColumns.add(new MeasurementSchema("__level" + i, TSDataType.STRING, TSEncoding.PLAIN, CompressionType.UNCOMPRESSED));
        }
        return generatedIdColumns;
    }

    public void finalizeColumnSchema() {
        if (!this.updatable) {
            return;
        }
        ArrayList<IMeasurementSchema> allColumns = new ArrayList<IMeasurementSchema>(this.generateIdColumns());
        List<ColumnCategory> allColumnCategories = ColumnCategory.nCopy(ColumnCategory.TAG, allColumns.size());
        allColumns.addAll(this.measurementSchemas);
        allColumnCategories.addAll(this.columnCategories);
        this.measurementSchemas = allColumns;
        this.columnCategories = allColumnCategories;
        this.updatable = false;
    }

    @Override
    public int serialize(OutputStream out) throws IOException {
        this.finalizeColumnSchema();
        return super.serialize(out);
    }
}

