/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.tsfile.file.metadata;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Objects;
import shaded.org.apache.tsfile.common.conf.TSFileConfig;
import shaded.org.apache.tsfile.exception.IllegalDeviceIDException;
import shaded.org.apache.tsfile.exception.TsFileRuntimeException;
import shaded.org.apache.tsfile.file.metadata.IDeviceID;
import shaded.org.apache.tsfile.read.common.parser.PathNodesGenerator;
import shaded.org.apache.tsfile.utils.RamUsageEstimator;
import shaded.org.apache.tsfile.utils.ReadWriteForEncodingUtils;
import shaded.org.apache.tsfile.utils.ReadWriteIOUtils;
import shaded.org.apache.tsfile.utils.WriteUtils;

public class StringArrayDeviceID
implements IDeviceID {
    private int serializedSize = -1;
    private static final IDeviceID.Deserializer DESERIALIZER = new IDeviceID.Deserializer(){

        @Override
        public IDeviceID deserializeFrom(ByteBuffer byteBuffer) {
            return StringArrayDeviceID.deserialize(byteBuffer);
        }

        @Override
        public IDeviceID deserializeFrom(InputStream inputStream) throws IOException {
            return StringArrayDeviceID.deserialize(inputStream);
        }
    };
    private static final IDeviceID.Factory FACTORY = new IDeviceID.Factory(){

        @Override
        public IDeviceID create(String deviceIdString) {
            return new StringArrayDeviceID(deviceIdString);
        }

        @Override
        public IDeviceID create(String[] segments) {
            return new StringArrayDeviceID(segments);
        }
    };
    private static final long INSTANCE_SIZE = RamUsageEstimator.shallowSizeOfInstance(StringArrayDeviceID.class);
    private final String[] segments;
    private int hash;
    private boolean hashIsZero;

    public StringArrayDeviceID(String ... deviceIdSegments) {
        this.segments = this.formalize(deviceIdSegments);
    }

    public StringArrayDeviceID(String deviceIdString) {
        this.segments = StringArrayDeviceID.splitDeviceIdString(deviceIdString);
    }

    private String[] formalize(String[] segments) {
        int i;
        for (i = segments.length - 1; i >= 0 && segments[i] == null; --i) {
        }
        if (i < 0) {
            throw new IllegalDeviceIDException("All segments are null");
        }
        if (i != segments.length - 1) {
            segments = Arrays.copyOf(segments, i + 1);
        }
        return segments;
    }

    public static String[] splitDeviceIdString(String deviceIdString) {
        return StringArrayDeviceID.splitDeviceIdString(PathNodesGenerator.splitPathToNodes(deviceIdString));
    }

    public static String[] splitDeviceIdString(String[] splits) {
        String[] finalSegments;
        int segmentCnt = splits.length;
        if (segmentCnt == 1) {
            finalSegments = new String[]{splits[0]};
        } else if (segmentCnt < TSFileConfig.DEFAULT_SEGMENT_NUM_FOR_TABLE_NAME + 1) {
            String tableName = String.join((CharSequence)".", Arrays.copyOfRange(splits, 0, segmentCnt - 1));
            finalSegments = new String[]{tableName, splits[segmentCnt - 1]};
        } else {
            String tableName = String.join((CharSequence)".", Arrays.copyOfRange(splits, 0, TSFileConfig.DEFAULT_SEGMENT_NUM_FOR_TABLE_NAME));
            String[] idSegments = Arrays.copyOfRange(splits, TSFileConfig.DEFAULT_SEGMENT_NUM_FOR_TABLE_NAME, segmentCnt);
            finalSegments = new String[idSegments.length + 1];
            finalSegments[0] = tableName;
            System.arraycopy(idSegments, 0, finalSegments, 1, idSegments.length);
        }
        return finalSegments;
    }

    public static IDeviceID.Deserializer getDESERIALIZER() {
        return DESERIALIZER;
    }

    public static IDeviceID.Factory getFACTORY() {
        return FACTORY;
    }

    @Override
    public int serialize(ByteBuffer byteBuffer) {
        int cnt = 0;
        cnt += ReadWriteForEncodingUtils.writeUnsignedVarInt(this.segments.length, byteBuffer);
        for (String segment : this.segments) {
            cnt += ReadWriteIOUtils.writeVar(segment, byteBuffer);
        }
        return cnt;
    }

    @Override
    public int serialize(OutputStream outputStream) throws IOException {
        int cnt = 0;
        cnt += ReadWriteForEncodingUtils.writeUnsignedVarInt(this.segments.length, outputStream);
        for (String segment : this.segments) {
            cnt += ReadWriteIOUtils.writeVar(segment, outputStream);
        }
        return cnt;
    }

    public static StringArrayDeviceID deserialize(ByteBuffer byteBuffer) {
        int cnt = ReadWriteForEncodingUtils.readUnsignedVarInt(byteBuffer);
        if (cnt == 0) {
            return new StringArrayDeviceID(new String[]{""});
        }
        String[] segments = new String[cnt];
        for (int i = 0; i < cnt; ++i) {
            segments[i] = ReadWriteIOUtils.readVarIntString(byteBuffer);
        }
        return new StringArrayDeviceID(segments);
    }

    public static StringArrayDeviceID deserialize(InputStream stream) throws IOException {
        int cnt = ReadWriteForEncodingUtils.readUnsignedVarInt(stream);
        if (cnt == 0) {
            return new StringArrayDeviceID(new String[]{""});
        }
        String[] segments = new String[cnt];
        for (int i = 0; i < cnt; ++i) {
            segments[i] = ReadWriteIOUtils.readVarIntString(stream);
        }
        return new StringArrayDeviceID(segments);
    }

    @Override
    public byte[] getBytes() {
        ByteArrayOutputStream publicBAOS = new ByteArrayOutputStream(256);
        try {
            this.serialize(publicBAOS);
        }
        catch (IOException e) {
            throw new TsFileRuntimeException(e);
        }
        return publicBAOS.toByteArray();
    }

    @Override
    public boolean isEmpty() {
        return this.segments == null || this.segments.length == 0;
    }

    @Override
    public boolean isTableModel() {
        return !this.segments[0].startsWith("root.");
    }

    @Override
    public String getTableName() {
        return this.segments[0];
    }

    @Override
    public int segmentNum() {
        return this.segments.length;
    }

    @Override
    public String segment(int i) {
        if (i >= this.segments.length) {
            return null;
        }
        return this.segments[i];
    }

    @Override
    public int compareTo(IDeviceID o) {
        if (this == o) {
            return 0;
        }
        int thisSegmentNum = this.segmentNum();
        int otherSegmentNum = o.segmentNum();
        for (int i = 0; i < thisSegmentNum; ++i) {
            if (i >= otherSegmentNum) {
                return 1;
            }
            int comp = Objects.compare(this.segment(i), (String)o.segment(i), WriteUtils::compareStrings);
            if (comp == 0) continue;
            return comp;
        }
        if (thisSegmentNum < otherSegmentNum) {
            return -1;
        }
        return 0;
    }

    @Override
    public long ramBytesUsed() {
        return INSTANCE_SIZE + RamUsageEstimator.sizeOf(this.segments);
    }

    @Override
    public int serializedSize() {
        if (this.serializedSize != -1) {
            return this.serializedSize;
        }
        int cnt = ReadWriteForEncodingUtils.varIntSize(this.segments.length);
        for (String segment : this.segments) {
            if (segment != null) {
                byte[] bytes = segment.getBytes(TSFileConfig.STRING_CHARSET);
                cnt += ReadWriteForEncodingUtils.varIntSize(bytes.length);
                cnt += bytes.length;
                continue;
            }
            cnt += ReadWriteForEncodingUtils.varIntSize(-1);
        }
        this.serializedSize = cnt;
        return cnt;
    }

    public String toString() {
        return String.join((CharSequence)".", this.segments);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StringArrayDeviceID deviceID = (StringArrayDeviceID)o;
        return Objects.deepEquals(this.segments, deviceID.segments);
    }

    public int hashCode() {
        int h = this.hash;
        if (h == 0 && !this.hashIsZero) {
            h = Arrays.hashCode(this.segments);
            if (h == 0) {
                this.hashIsZero = true;
            } else {
                this.hash = h;
            }
        }
        return h;
    }

    public String[] getSegments() {
        return this.segments;
    }
}

