/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.tsfile.file.metadata.enums;

public enum EncryptionType {
    UNENCRYPTED("UNENCRYPTED", 0),
    SM4128("SM4128", 1),
    AES128("AES128", 2),
    NewWay("NewWay", 3);

    private final String extensionName;
    private final byte index;

    private EncryptionType(String extensionName, byte index) {
        this.extensionName = extensionName;
        this.index = index;
    }

    public static EncryptionType deserialize(byte encryptor) {
        switch (encryptor) {
            case 0: {
                return UNENCRYPTED;
            }
            case 1: {
                return SM4128;
            }
            case 2: {
                return AES128;
            }
        }
        return NewWay;
    }

    public static int getSerializedSize() {
        return 1;
    }

    public byte serialize() {
        return this.index;
    }

    public String getExtension() {
        return this.extensionName;
    }
}

