/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.tsfile.file.metadata.statistics;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Objects;
import shaded.org.apache.tsfile.common.conf.TSFileConfig;
import shaded.org.apache.tsfile.enums.TSDataType;
import shaded.org.apache.tsfile.exception.filter.StatisticsClassException;
import shaded.org.apache.tsfile.file.metadata.statistics.Statistics;
import shaded.org.apache.tsfile.utils.Binary;
import shaded.org.apache.tsfile.utils.RamUsageEstimator;
import shaded.org.apache.tsfile.utils.ReadWriteIOUtils;

public class StringStatistics
extends Statistics<Binary> {
    public static final long INSTANCE_SIZE = RamUsageEstimator.shallowSizeOfInstance(StringStatistics.class) + 4L * RamUsageEstimator.shallowSizeOfInstance(Binary.class);
    private static final Binary EMPTY_VALUE = new Binary("", TSFileConfig.STRING_CHARSET);
    private Binary firstValue = EMPTY_VALUE;
    private Binary lastValue = EMPTY_VALUE;
    private Binary minValue = EMPTY_VALUE;
    private Binary maxValue = EMPTY_VALUE;

    @Override
    public TSDataType getType() {
        return TSDataType.STRING;
    }

    @Override
    public int getStatsSize() {
        return 16 + this.firstValue.getValues().length + this.lastValue.getValues().length + this.minValue.getValues().length + this.maxValue.getValues().length;
    }

    @Override
    public long getRetainedSizeInBytes() {
        return INSTANCE_SIZE + RamUsageEstimator.sizeOfCharArray(this.firstValue.getLength()) + RamUsageEstimator.sizeOfCharArray(this.lastValue.getLength()) + RamUsageEstimator.sizeOfCharArray(this.minValue.getLength()) + RamUsageEstimator.sizeOfCharArray(this.maxValue.getLength());
    }

    public void initializeStats(Binary first, Binary last, Binary min, Binary max) {
        this.firstValue = first;
        this.lastValue = last;
        this.minValue = min;
        this.maxValue = max;
    }

    private void updateStats(Binary minValue, Binary maxValue, Binary lastValue) {
        if (this.minValue.compareTo(minValue) > 0) {
            this.minValue = minValue;
        }
        if (this.maxValue.compareTo(maxValue) < 0) {
            this.maxValue = maxValue;
        }
        this.lastValue = lastValue;
    }

    private void updateStats(Binary firstValue, Binary lastValue, Binary minValue, Binary maxValue, long startTime, long endTime) {
        if (this.minValue.compareTo(minValue) > 0) {
            this.minValue = minValue;
        }
        if (this.maxValue.compareTo(maxValue) < 0) {
            this.maxValue = maxValue;
        }
        if (startTime <= this.getStartTime()) {
            this.firstValue = firstValue;
        }
        if (endTime >= this.getEndTime()) {
            this.lastValue = lastValue;
        }
    }

    @Override
    public Binary getMinValue() {
        return this.minValue;
    }

    @Override
    public Binary getMaxValue() {
        return this.maxValue;
    }

    @Override
    public Binary getFirstValue() {
        return this.firstValue;
    }

    @Override
    public Binary getLastValue() {
        return this.lastValue;
    }

    @Override
    public double getSumDoubleValue() {
        throw new StatisticsClassException(String.format("%s statistics does not support: %s", new Object[]{TSDataType.STRING, "double sum"}));
    }

    @Override
    public long getSumLongValue() {
        throw new StatisticsClassException(String.format("%s statistics does not support: %s", new Object[]{TSDataType.STRING, "long sum"}));
    }

    @Override
    protected void mergeStatisticsValue(Statistics stats) {
        if (stats instanceof StringStatistics) {
            if (this.isEmpty) {
                this.initializeStats((Binary)stats.getFirstValue(), (Binary)stats.getLastValue(), (Binary)stats.getMinValue(), (Binary)stats.getMaxValue());
                this.isEmpty = false;
            } else {
                this.updateStats((Binary)stats.getFirstValue(), (Binary)stats.getLastValue(), (Binary)stats.getMinValue(), (Binary)stats.getMaxValue(), stats.getStartTime(), stats.getEndTime());
            }
        } else {
            throw new StatisticsClassException(this.getClass(), stats.getClass());
        }
    }

    @Override
    void updateStats(Binary value) {
        if (this.isEmpty) {
            this.initializeStats(value, value, value, value);
            this.isEmpty = false;
        } else {
            this.updateStats(value, value, value);
        }
    }

    @Override
    void updateStats(Binary[] values, int batchSize) {
        for (int i = 0; i < batchSize; ++i) {
            this.updateStats(values[i]);
        }
    }

    @Override
    public int serializeStats(OutputStream outputStream) throws IOException {
        int byteLen = 0;
        byteLen += ReadWriteIOUtils.write(this.firstValue, outputStream);
        byteLen += ReadWriteIOUtils.write(this.lastValue, outputStream);
        byteLen += ReadWriteIOUtils.write(this.minValue, outputStream);
        return byteLen += ReadWriteIOUtils.write(this.maxValue, outputStream);
    }

    @Override
    public void deserialize(InputStream inputStream) throws IOException {
        this.firstValue = ReadWriteIOUtils.readBinary(inputStream);
        this.lastValue = ReadWriteIOUtils.readBinary(inputStream);
        this.minValue = ReadWriteIOUtils.readBinary(inputStream);
        this.maxValue = ReadWriteIOUtils.readBinary(inputStream);
    }

    @Override
    public void deserialize(ByteBuffer byteBuffer) {
        this.firstValue = ReadWriteIOUtils.readBinary(byteBuffer);
        this.lastValue = ReadWriteIOUtils.readBinary(byteBuffer);
        this.minValue = ReadWriteIOUtils.readBinary(byteBuffer);
        this.maxValue = ReadWriteIOUtils.readBinary(byteBuffer);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        StringStatistics that = (StringStatistics)o;
        return this.firstValue.equals(that.firstValue) && this.lastValue.equals(that.lastValue) && this.minValue.equals(that.minValue) && this.maxValue.equals(that.maxValue);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.firstValue, this.lastValue, this.minValue, this.maxValue);
    }

    @Override
    public String toString() {
        return super.toString() + " [firstValue:" + this.firstValue + ", lastValue:" + this.lastValue + ", minValue:" + this.minValue + ", maxValue:" + this.maxValue + "]";
    }
}

