/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.tsfile.file.metadata.statistics;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import shaded.org.apache.tsfile.enums.TSDataType;
import shaded.org.apache.tsfile.exception.filter.StatisticsClassException;
import shaded.org.apache.tsfile.file.metadata.statistics.Statistics;
import shaded.org.apache.tsfile.utils.RamUsageEstimator;

public class TimeStatistics
extends Statistics<Long> {
    public static final long INSTANCE_SIZE = RamUsageEstimator.shallowSizeOfInstance(TimeStatistics.class);
    private static final String TIME = "Time";
    private static final String UPDATE_STATS = "update stats";

    @Override
    public TSDataType getType() {
        return TSDataType.VECTOR;
    }

    @Override
    public int getStatsSize() {
        return 0;
    }

    @Override
    public long getRetainedSizeInBytes() {
        return INSTANCE_SIZE;
    }

    @Override
    public void update(long time) {
        super.update(time);
        this.setEmpty(false);
    }

    @Override
    public void update(long[] time, int batchSize) {
        super.update(time, batchSize);
        if (batchSize > 0) {
            this.setEmpty(false);
        }
    }

    @Override
    public void update(long[] time, int batchSize, int arrayOffset) {
        super.update(time, batchSize, arrayOffset);
        if (batchSize > 0) {
            this.setEmpty(false);
        }
    }

    @Override
    public Long getMinValue() {
        return this.getStartTime();
    }

    @Override
    public Long getMaxValue() {
        return this.getEndTime();
    }

    @Override
    public Long getFirstValue() {
        return this.getStartTime();
    }

    @Override
    public Long getLastValue() {
        return this.getEndTime();
    }

    @Override
    public double getSumDoubleValue() {
        throw new StatisticsClassException(String.format("%s statistics does not support: %s", TIME, "double sum"));
    }

    @Override
    public long getSumLongValue() {
        throw new StatisticsClassException(String.format("%s statistics does not support: %s", TIME, "long sum"));
    }

    @Override
    void updateStats(long value) {
        throw new StatisticsClassException(String.format("%s statistics does not support: %s", TIME, UPDATE_STATS));
    }

    @Override
    void updateStats(long[] values, int batchSize) {
        throw new StatisticsClassException(String.format("%s statistics does not support: %s", TIME, UPDATE_STATS));
    }

    @Override
    public void updateStats(long minValue, long maxValue) {
        throw new StatisticsClassException(String.format("%s statistics does not support: %s", TIME, UPDATE_STATS));
    }

    @Override
    protected void mergeStatisticsValue(Statistics stats) {
    }

    @Override
    public int serializeStats(OutputStream outputStream) {
        return 0;
    }

    @Override
    public void deserialize(InputStream inputStream) throws IOException {
    }

    @Override
    public void deserialize(ByteBuffer byteBuffer) {
    }
}

