/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.tsfile.fileSystem.fileInputFactory;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import shaded.org.apache.tsfile.common.conf.TSFileDescriptor;
import shaded.org.apache.tsfile.fileSystem.fileInputFactory.FileInputFactory;
import shaded.org.apache.tsfile.read.reader.TsFileInput;

public class HDFSInputFactory
implements FileInputFactory {
    private static final Logger logger = LoggerFactory.getLogger(HDFSInputFactory.class);
    private Constructor constructor;

    public HDFSInputFactory() {
        try {
            Class<?> clazz = Class.forName(TSFileDescriptor.getInstance().getConfig().getHdfsTsFileInput());
            this.constructor = clazz.getConstructor(String.class);
        }
        catch (ClassNotFoundException | NoSuchMethodException e) {
            logger.error("Failed to get HDFSInput in Hadoop file system. Please check your dependency of Hadoop module.", e);
        }
    }

    @Override
    public TsFileInput getTsFileInput(String filePath) throws IOException {
        try {
            return (TsFileInput)this.constructor.newInstance(filePath);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new IOException(String.format("Failed to get TsFile input of file: %s. Please check your dependency of Hadoop module.", filePath), e);
        }
    }
}

