/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.tsfile.fileSystem.fsFactory;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import shaded.org.apache.tsfile.fileSystem.FSPath;
import shaded.org.apache.tsfile.fileSystem.FSType;
import shaded.org.apache.tsfile.fileSystem.fsFactory.FSFactory;
import shaded.org.apache.tsfile.fileSystem.fsFactory.HDFSFactory;
import shaded.org.apache.tsfile.fileSystem.fsFactory.LocalFSFactory;
import shaded.org.apache.tsfile.fileSystem.fsFactory.OSFSFactory;
import shaded.org.apache.tsfile.utils.FSUtils;

public class HybridFSFactory
implements FSFactory {
    private static final Logger logger = LoggerFactory.getLogger(HybridFSFactory.class);
    private static final Map<FSType, FSFactory> fsFactories = new ConcurrentHashMap<FSType, FSFactory>();

    private FSFactory getFSFactory(FSType fsType) {
        return fsFactories.compute(fsType, (k, v) -> {
            if (v != null) {
                return v;
            }
            switch (fsType) {
                case LOCAL: {
                    return new LocalFSFactory();
                }
                case OBJECT_STORAGE: {
                    return new OSFSFactory();
                }
                case HDFS: {
                    return new HDFSFactory();
                }
            }
            return null;
        });
    }

    @Override
    public File getFileWithParent(String pathname) {
        FSPath path = FSUtils.parse(pathname);
        return this.getFSFactory(path.getFsType()).getFileWithParent(path.getPath());
    }

    @Override
    public File getFile(String pathname) {
        FSPath path = FSUtils.parse(pathname);
        return this.getFSFactory(path.getFsType()).getFile(path.getPath());
    }

    @Override
    public File getFile(String parent, String child) {
        FSPath parentPath = FSUtils.parse(parent);
        return this.getFSFactory(parentPath.getFsType()).getFile(parentPath.getPath(), child);
    }

    @Override
    public File getFile(File parent, String child) {
        FSType type = FSUtils.getFSType(parent);
        return this.getFSFactory(type).getFile(parent, child);
    }

    @Override
    public File getFile(URI uri) {
        throw new UnsupportedOperationException();
    }

    @Override
    public BufferedReader getBufferedReader(String filePath) {
        FSPath path = FSUtils.parse(filePath);
        return this.getFSFactory(path.getFsType()).getBufferedReader(path.getPath());
    }

    @Override
    public BufferedWriter getBufferedWriter(String filePath, boolean append) {
        FSPath path = FSUtils.parse(filePath);
        return this.getFSFactory(path.getFsType()).getBufferedWriter(path.getPath(), append);
    }

    @Override
    public InputStream getBufferedInputStream(String filePath) {
        FSPath path = FSUtils.parse(filePath);
        return this.getFSFactory(path.getFsType()).getBufferedInputStream(path.getPath());
    }

    @Override
    public OutputStream getBufferedOutputStream(String filePath) {
        FSPath path = FSUtils.parse(filePath);
        return this.getFSFactory(path.getFsType()).getBufferedOutputStream(path.getPath());
    }

    @Override
    public void moveFile(File srcFile, File destFile) throws IOException {
        FSType destType;
        FSType srcType = FSUtils.getFSType(srcFile);
        if (srcType != (destType = FSUtils.getFSType(destFile))) {
            throw new IOException(String.format("Doesn't support move file from %s to %s.", new Object[]{srcType, destType}));
        }
        this.getFSFactory(destType).moveFile(srcFile, destFile);
    }

    @Override
    public void copyFile(File srcFile, File destFile) throws IOException {
        FSType destType;
        FSType srcType = FSUtils.getFSType(srcFile);
        if (srcType == (destType = FSUtils.getFSType(destFile)) || srcType == FSType.LOCAL && destType == FSType.OBJECT_STORAGE) {
            this.getFSFactory(destType).copyFile(srcFile, destFile);
        } else if (!(srcType != FSType.LOCAL && srcType != FSType.HDFS || destType != FSType.LOCAL && destType != FSType.HDFS)) {
            this.getFSFactory(FSType.HDFS).copyFile(srcFile, destFile);
        } else {
            throw new IOException(String.format("Doesn't support move file from %s to %s.", new Object[]{srcType, destType}));
        }
    }

    @Override
    public File[] listFilesBySuffix(String fileFolder, String suffix) {
        FSPath folder = FSUtils.parse(fileFolder);
        return this.getFSFactory(folder.getFsType()).listFilesBySuffix(folder.getPath(), suffix);
    }

    @Override
    public File[] listFilesByPrefix(String fileFolder, String prefix) {
        FSPath folder = FSUtils.parse(fileFolder);
        return this.getFSFactory(folder.getFsType()).listFilesByPrefix(folder.getPath(), prefix);
    }

    @Override
    public boolean deleteIfExists(File file) throws IOException {
        FSType type = FSUtils.getFSType(file);
        return this.getFSFactory(type).deleteIfExists(file);
    }

    @Override
    public void deleteDirectory(String dir) throws IOException {
        FSType type = FSUtils.getFSType(dir);
        this.getFSFactory(type).deleteDirectory(dir);
    }
}

