/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.tsfile.read;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import shaded.org.apache.tsfile.file.metadata.AlignedChunkMetadata;
import shaded.org.apache.tsfile.file.metadata.ChunkMetadata;
import shaded.org.apache.tsfile.file.metadata.IChunkMetadata;
import shaded.org.apache.tsfile.read.TsFileSequenceReader;
import shaded.org.apache.tsfile.read.common.Chunk;
import shaded.org.apache.tsfile.read.reader.chunk.AlignedChunkReader;
import shaded.org.apache.tsfile.write.schema.IMeasurementSchema;

public class TsFileAlignedSeriesReaderIterator {
    private TsFileSequenceReader reader;
    private List<AlignedChunkMetadata> alignedChunkMetadataList;
    private List<IMeasurementSchema> schemaList;
    private int curIdx = -1;

    public TsFileAlignedSeriesReaderIterator(TsFileSequenceReader reader, List<AlignedChunkMetadata> alignedChunkMetadataList, List<IMeasurementSchema> schemaList) {
        this.reader = reader;
        this.alignedChunkMetadataList = alignedChunkMetadataList;
        this.schemaList = schemaList;
    }

    public boolean hasNext() {
        return this.curIdx < this.alignedChunkMetadataList.size() - 1;
    }

    public NextAlignedChunkInfo nextReader() throws IOException {
        AlignedChunkMetadata alignedChunkMetadata = this.alignedChunkMetadataList.get(++this.curIdx);
        IChunkMetadata timeChunkMetadata = alignedChunkMetadata.getTimeChunkMetadata();
        List<IChunkMetadata> valueChunkMetadataList = alignedChunkMetadata.getValueChunkMetadataList();
        int schemaIdx = 0;
        Chunk timeChunk = this.reader.readMemChunk((ChunkMetadata)timeChunkMetadata);
        Chunk[] valueChunks = new Chunk[this.schemaList.size()];
        long totalSize = 0L;
        long totalPointNum = 0L;
        int notNullChunkNum = 0;
        for (IChunkMetadata valueChunkMetadata : valueChunkMetadataList) {
            if (valueChunkMetadata == null) continue;
            while (!valueChunkMetadata.getMeasurementUid().equals(this.schemaList.get(schemaIdx).getMeasurementName())) {
                ++schemaIdx;
            }
            Chunk chunk = this.reader.readMemChunk((ChunkMetadata)valueChunkMetadata);
            valueChunks[schemaIdx++] = chunk;
            ++notNullChunkNum;
            totalPointNum += ((ChunkMetadata)valueChunkMetadata).getNumOfPoints();
            totalSize += (long)(chunk.getHeader().getSerializedSize() + chunk.getHeader().getDataSize());
        }
        AlignedChunkReader chunkReader = new AlignedChunkReader(timeChunk, Arrays.asList(valueChunks));
        return new NextAlignedChunkInfo(chunkReader, totalSize, notNullChunkNum, totalPointNum);
    }

    public class NextAlignedChunkInfo {
        private AlignedChunkReader reader;
        private long totalSize;
        private int notNullChunkNum;
        private long totalPointNum;

        public NextAlignedChunkInfo(AlignedChunkReader reader, long totalSize, int notNullChunkNum, long totalPointNum) {
            this.reader = reader;
            this.totalSize = totalSize;
            this.notNullChunkNum = notNullChunkNum;
            this.totalPointNum = totalPointNum;
        }

        public AlignedChunkReader getReader() {
            return this.reader;
        }

        public long getTotalSize() {
            return this.totalSize;
        }

        public long getTotalPointNum() {
            return this.totalPointNum;
        }

        public int getNotNullChunkNum() {
            return this.notNullChunkNum;
        }
    }
}

