/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.tsfile.read;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Queue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import shaded.org.apache.tsfile.compatibility.DeserializeConfig;
import shaded.org.apache.tsfile.exception.StopReadTsFileByInterruptException;
import shaded.org.apache.tsfile.exception.TsFileRuntimeException;
import shaded.org.apache.tsfile.file.IMetadataIndexEntry;
import shaded.org.apache.tsfile.file.metadata.DeviceMetadataIndexEntry;
import shaded.org.apache.tsfile.file.metadata.IDeviceID;
import shaded.org.apache.tsfile.file.metadata.MetadataIndexNode;
import shaded.org.apache.tsfile.file.metadata.enums.MetadataIndexNodeType;
import shaded.org.apache.tsfile.read.TsFileSequenceReader;
import shaded.org.apache.tsfile.utils.Pair;
import shaded.org.apache.tsfile.utils.ReadWriteIOUtils;

public class TsFileDeviceIterator
implements Iterator<Pair<IDeviceID, Boolean>> {
    private final TsFileSequenceReader reader;
    private final DeserializeConfig deserializeConfig;
    private final Iterator<MetadataIndexNode> tableMetadataIndexNodeIterator;
    private final Queue<Pair<IDeviceID, long[]>> queue = new LinkedList<Pair<IDeviceID, long[]>>();
    private final List<long[]> leafDeviceNodeOffsetList = new LinkedList<long[]>();
    private Pair<IDeviceID, Boolean> currentDevice = null;
    private MetadataIndexNode measurementNode;
    private static final Logger logger = LoggerFactory.getLogger(TsFileDeviceIterator.class);

    public TsFileDeviceIterator(TsFileSequenceReader reader) throws IOException {
        this.reader = reader;
        this.deserializeConfig = reader.getDeserializeContext();
        this.tableMetadataIndexNodeIterator = reader.readFileMetadata().getTableMetadataIndexNodeMap().values().iterator();
    }

    public Pair<IDeviceID, Boolean> current() {
        return this.currentDevice;
    }

    @Override
    public boolean hasNext() {
        try {
            this.prepareNextTable();
            if (!this.queue.isEmpty()) {
                return true;
            }
            if (this.leafDeviceNodeOffsetList.isEmpty()) {
                return false;
            }
            long[] nextDeviceLeafNodeOffset = this.leafDeviceNodeOffsetList.remove(0);
            this.getDevicesAndEntriesOfOneLeafNode(nextDeviceLeafNodeOffset[0], nextDeviceLeafNodeOffset[1], this.queue);
            return true;
        }
        catch (IOException e) {
            throw new TsFileRuntimeException(e);
        }
    }

    private void prepareNextTable() throws IOException {
        if (!this.queue.isEmpty() || !this.leafDeviceNodeOffsetList.isEmpty()) {
            return;
        }
        if (!this.tableMetadataIndexNodeIterator.hasNext()) {
            return;
        }
        MetadataIndexNode nextTableMetadataIndexNode = this.tableMetadataIndexNodeIterator.next();
        if (nextTableMetadataIndexNode.getNodeType().equals((Object)MetadataIndexNodeType.LEAF_DEVICE)) {
            this.getDevicesOfLeafNode(nextTableMetadataIndexNode, this.queue);
        } else {
            this.getAllDeviceLeafNodeOffset(nextTableMetadataIndexNode, this.leafDeviceNodeOffsetList);
        }
    }

    @Override
    public Pair<IDeviceID, Boolean> next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        Pair<IDeviceID, long[]> startEndPair = this.queue.remove();
        try {
            this.measurementNode = this.reader.readMetadataIndexNode(((long[])startEndPair.right)[0], ((long[])startEndPair.right)[1], false);
            boolean isAligned = this.reader.isAlignedDevice(this.measurementNode);
            this.currentDevice = new Pair<IDeviceID, Boolean>((IDeviceID)startEndPair.left, isAligned);
            return this.currentDevice;
        }
        catch (IOException e) {
            throw new TsFileRuntimeException("Error occurred while reading a time series metadata block.");
        }
    }

    public MetadataIndexNode getFirstMeasurementNodeOfCurrentDevice() {
        return this.measurementNode;
    }

    public void getDevicesAndEntriesOfOneLeafNode(Long startOffset, Long endOffset, Queue<Pair<IDeviceID, long[]>> measurementNodeOffsetQueue) throws IOException {
        try {
            ByteBuffer nextBuffer = this.reader.readData((long)startOffset, endOffset);
            MetadataIndexNode deviceLeafNode = this.deserializeConfig.deviceMetadataIndexNodeBufferDeserializer.deserialize(nextBuffer, this.deserializeConfig);
            this.getDevicesOfLeafNode(deviceLeafNode, measurementNodeOffsetQueue);
        }
        catch (StopReadTsFileByInterruptException e) {
            throw e;
        }
        catch (Exception e) {
            logger.error("Something error happened while getting all devices of file {}", (Object)this.reader.getFileName());
            throw e;
        }
    }

    private void getDevicesOfLeafNode(MetadataIndexNode deviceLeafNode, Queue<Pair<IDeviceID, long[]>> measurementNodeOffsetQueue) {
        if (!deviceLeafNode.getNodeType().equals((Object)MetadataIndexNodeType.LEAF_DEVICE)) {
            throw new IllegalStateException("the first param should be device leaf node.");
        }
        List<IMetadataIndexEntry> childrenEntries = deviceLeafNode.getChildren();
        for (int i = 0; i < childrenEntries.size(); ++i) {
            IMetadataIndexEntry deviceEntry = childrenEntries.get(i);
            long childStartOffset = deviceEntry.getOffset();
            long childEndOffset = i == childrenEntries.size() - 1 ? deviceLeafNode.getEndOffset() : childrenEntries.get(i + 1).getOffset();
            long[] offset = new long[]{childStartOffset, childEndOffset};
            measurementNodeOffsetQueue.add(new Pair<IDeviceID, long[]>(((DeviceMetadataIndexEntry)deviceEntry).getDeviceID(), offset));
        }
    }

    private void getAllDeviceLeafNodeOffset(MetadataIndexNode deviceInternalNode, List<long[]> leafDeviceNodeOffsets) throws IOException {
        if (!deviceInternalNode.getNodeType().equals((Object)MetadataIndexNodeType.INTERNAL_DEVICE)) {
            throw new IllegalStateException("the first param should be device internal node.");
        }
        try {
            int metadataIndexListSize = deviceInternalNode.getChildren().size();
            boolean isCurrentLayerLeafNode = false;
            for (int i = 0; i < metadataIndexListSize; ++i) {
                IMetadataIndexEntry entry = deviceInternalNode.getChildren().get(i);
                long startOffset = entry.getOffset();
                long endOffset = deviceInternalNode.getEndOffset();
                if (i != metadataIndexListSize - 1) {
                    endOffset = deviceInternalNode.getChildren().get(i + 1).getOffset();
                }
                if (i == 0) {
                    MetadataIndexNodeType nodeType = MetadataIndexNodeType.deserialize(ReadWriteIOUtils.readByte(this.reader.readData(endOffset - 1L, endOffset)));
                    isCurrentLayerLeafNode = nodeType.equals((Object)MetadataIndexNodeType.LEAF_DEVICE);
                }
                if (isCurrentLayerLeafNode) {
                    long[] offset = new long[]{startOffset, endOffset};
                    leafDeviceNodeOffsets.add(offset);
                    continue;
                }
                ByteBuffer nextBuffer = this.reader.readData(startOffset, endOffset);
                this.getAllDeviceLeafNodeOffset(this.deserializeConfig.deviceMetadataIndexNodeBufferDeserializer.deserialize(nextBuffer, this.deserializeConfig), leafDeviceNodeOffsets);
            }
        }
        catch (StopReadTsFileByInterruptException e) {
            throw e;
        }
        catch (Exception e) {
            logger.error("Something error happened while getting all devices of file {}", (Object)this.reader.getFileName());
            throw e;
        }
    }
}

