/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.tsfile.read;

import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import shaded.org.apache.tsfile.fileSystem.FSFactoryProducer;
import shaded.org.apache.tsfile.read.TsFileSequenceReader;
import shaded.org.apache.tsfile.write.TsFileWriter;
import shaded.org.apache.tsfile.write.writer.RestorableTsFileIOWriter;

public class TsFileRestorableReader
extends TsFileSequenceReader {
    private static final Logger logger = LoggerFactory.getLogger(TsFileRestorableReader.class);

    public TsFileRestorableReader(String file) throws IOException {
        this(file, true);
    }

    public TsFileRestorableReader(String file, boolean autoRepair) throws IOException {
        super(file, !autoRepair);
        if (autoRepair) {
            try {
                this.checkAndRepair();
            }
            catch (Throwable e) {
                this.close();
                throw e;
            }
            this.loadMetadataSize();
        }
    }

    private void checkAndRepair() throws IOException {
        if (!this.isComplete()) {
            logger.info("File {} has no correct tail magic, try to repair...", (Object)this.file);
            try (RestorableTsFileIOWriter rWriter = new RestorableTsFileIOWriter(FSFactoryProducer.getFSFactory().getFile(this.file));){
                TsFileWriter writer = new TsFileWriter(rWriter);
                writer.close();
            }
        }
    }
}

