/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.tsfile.read;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import shaded.org.apache.tsfile.compatibility.DeserializeConfig;
import shaded.org.apache.tsfile.exception.TsFileSequenceReaderTimeseriesMetadataIteratorException;
import shaded.org.apache.tsfile.file.IMetadataIndexEntry;
import shaded.org.apache.tsfile.file.metadata.DeviceMetadataIndexEntry;
import shaded.org.apache.tsfile.file.metadata.IDeviceID;
import shaded.org.apache.tsfile.file.metadata.MetadataIndexNode;
import shaded.org.apache.tsfile.file.metadata.TimeseriesMetadata;
import shaded.org.apache.tsfile.file.metadata.enums.MetadataIndexNodeType;
import shaded.org.apache.tsfile.read.TsFileSequenceReader;

public class TsFileSequenceReaderTimeseriesMetadataIterator
implements Iterator<Map<IDeviceID, List<TimeseriesMetadata>>> {
    private static final int DEFAULT_TIMESERIES_BATCH_READ_NUMBER = 4000;
    private final TsFileSequenceReader reader;
    private final boolean needChunkMetadata;
    private final int timeseriesBatchReadNumber;
    private ByteBuffer currentBuffer = null;
    private long currentEndOffset = Long.MIN_VALUE;
    private final Deque<MetadataIndexEntryInfo> metadataIndexEntryStack = new ArrayDeque<MetadataIndexEntryInfo>();
    private IDeviceID currentDeviceId;
    private int currentTimeseriesMetadataCount = 0;
    private DeserializeConfig deserializeConfig;

    public TsFileSequenceReaderTimeseriesMetadataIterator(TsFileSequenceReader reader, boolean needChunkMetadata, int timeseriesBatchReadNumber) throws IOException {
        this.reader = reader;
        this.needChunkMetadata = needChunkMetadata;
        this.timeseriesBatchReadNumber = timeseriesBatchReadNumber;
        this.deserializeConfig = this.reader.getDeserializeContext();
        if (this.reader.tsFileMetaData == null) {
            this.reader.readFileMetadata();
        }
        for (MetadataIndexNode metadataIndexNode : reader.tsFileMetaData.getTableMetadataIndexNodeMap().values()) {
            long curEntryEndOffset = metadataIndexNode.getEndOffset();
            List<IMetadataIndexEntry> metadataIndexEntryList = metadataIndexNode.getChildren();
            for (int i = metadataIndexEntryList.size() - 1; i >= 0; --i) {
                this.metadataIndexEntryStack.push(new MetadataIndexEntryInfo(metadataIndexEntryList.get(i), metadataIndexNode.getNodeType(), curEntryEndOffset));
                curEntryEndOffset = metadataIndexEntryList.get(i).getOffset();
            }
        }
    }

    public TsFileSequenceReaderTimeseriesMetadataIterator(TsFileSequenceReader reader, boolean needChunkMetadata) throws IOException {
        this(reader, needChunkMetadata, 4000);
    }

    @Override
    public boolean hasNext() {
        return !this.metadataIndexEntryStack.isEmpty() || this.currentBuffer != null && this.currentBuffer.hasRemaining();
    }

    @Override
    public Map<IDeviceID, List<TimeseriesMetadata>> next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        HashMap<IDeviceID, List<TimeseriesMetadata>> timeseriesMetadataMap = new HashMap<IDeviceID, List<TimeseriesMetadata>>();
        while (this.currentTimeseriesMetadataCount < this.timeseriesBatchReadNumber) {
            if (this.currentBuffer != null && this.currentBuffer.hasRemaining()) {
                timeseriesMetadataMap.computeIfAbsent(this.currentDeviceId, k -> new ArrayList()).addAll(this.deserializeTimeseriesMetadata());
            } else if (this.currentEndOffset > Long.MIN_VALUE) {
                try {
                    timeseriesMetadataMap.computeIfAbsent(this.currentDeviceId, k -> new ArrayList()).addAll(this.deserializeTimeseriesMetadataUsingTsFileInput(this.currentEndOffset));
                }
                catch (IOException e) {
                    throw new TsFileSequenceReaderTimeseriesMetadataIteratorException(String.format("TsFileSequenceReaderTimeseriesMetadataIterator: deserializeTimeseriesMetadataUsingTsFileInput failed, currentEndOffset: %d, " + e.getMessage(), this.currentEndOffset));
                }
            }
            if (this.currentTimeseriesMetadataCount >= this.timeseriesBatchReadNumber || this.metadataIndexEntryStack.isEmpty()) break;
            MetadataIndexEntryInfo indexEntryInfo = this.metadataIndexEntryStack.pop();
            try {
                this.deserializeMetadataIndexEntry(indexEntryInfo, timeseriesMetadataMap);
            }
            catch (IOException e) {
                throw new TsFileSequenceReaderTimeseriesMetadataIteratorException(String.format("TsFileSequenceReaderTimeseriesMetadataIterator: deserializeMetadataIndexEntry failed, MetadataIndexEntryInfo: %s, " + e.getMessage(), indexEntryInfo));
            }
        }
        if (this.currentTimeseriesMetadataCount >= this.timeseriesBatchReadNumber) {
            this.currentTimeseriesMetadataCount = 0;
        }
        return timeseriesMetadataMap;
    }

    private void deserializeMetadataIndexEntry(MetadataIndexEntryInfo metadataIndexEntryInfo, Map<IDeviceID, List<TimeseriesMetadata>> timeseriesMetadataMap) throws IOException {
        if (metadataIndexEntryInfo.getMetadataIndexNodeType().equals((Object)MetadataIndexNodeType.LEAF_MEASUREMENT)) {
            this.deserializeLeafMeasurement(metadataIndexEntryInfo.getMetadataIndexEntry(), metadataIndexEntryInfo.getEndOffset(), timeseriesMetadataMap);
        } else {
            this.deserializeInternalNode(metadataIndexEntryInfo.getMetadataIndexEntry(), metadataIndexEntryInfo.getEndOffset(), metadataIndexEntryInfo.getMetadataIndexNodeType());
        }
    }

    private void deserializeLeafMeasurement(IMetadataIndexEntry metadataIndexEntry, long endOffset, Map<IDeviceID, List<TimeseriesMetadata>> timeseriesMetadataMap) throws IOException {
        if (this.currentBuffer != null && this.currentBuffer.hasRemaining()) {
            throw new TsFileSequenceReaderTimeseriesMetadataIteratorException("currentBuffer still has some data left before deserializeLeafMeasurement");
        }
        if (endOffset - metadataIndexEntry.getOffset() < Integer.MAX_VALUE) {
            this.currentBuffer = this.reader.readData(metadataIndexEntry.getOffset(), endOffset);
            timeseriesMetadataMap.computeIfAbsent(this.currentDeviceId, k -> new ArrayList()).addAll(this.deserializeTimeseriesMetadata());
        } else {
            this.currentEndOffset = endOffset;
            this.reader.position(metadataIndexEntry.getOffset());
            timeseriesMetadataMap.computeIfAbsent(this.currentDeviceId, k -> new ArrayList()).addAll(this.deserializeTimeseriesMetadataUsingTsFileInput(endOffset));
        }
    }

    private List<TimeseriesMetadata> deserializeTimeseriesMetadata() {
        ArrayList<TimeseriesMetadata> timeseriesMetadataList = new ArrayList<TimeseriesMetadata>();
        while (this.currentBuffer.hasRemaining() && this.currentTimeseriesMetadataCount < this.timeseriesBatchReadNumber) {
            timeseriesMetadataList.add(TimeseriesMetadata.deserializeFrom(this.currentBuffer, this.needChunkMetadata));
            ++this.currentTimeseriesMetadataCount;
        }
        return timeseriesMetadataList;
    }

    private List<TimeseriesMetadata> deserializeTimeseriesMetadataUsingTsFileInput(long endOffset) throws IOException {
        ArrayList<TimeseriesMetadata> timeseriesMetadataList = new ArrayList<TimeseriesMetadata>();
        while (this.reader.position() < endOffset && this.currentTimeseriesMetadataCount < 4000) {
            timeseriesMetadataList.add(TimeseriesMetadata.deserializeFrom(this.reader.tsFileInput, this.needChunkMetadata));
            ++this.currentTimeseriesMetadataCount;
        }
        if (this.reader.position() >= endOffset) {
            this.currentEndOffset = Long.MIN_VALUE;
        }
        return timeseriesMetadataList;
    }

    private void deserializeInternalNode(IMetadataIndexEntry metadataIndexEntry, long endOffset, MetadataIndexNodeType type) throws IOException {
        if (MetadataIndexNodeType.LEAF_DEVICE.equals((Object)type)) {
            this.currentDeviceId = ((DeviceMetadataIndexEntry)metadataIndexEntry).getDeviceID();
        }
        boolean currentChildLevelIsDevice = MetadataIndexNodeType.INTERNAL_DEVICE.equals((Object)type);
        MetadataIndexNode metadataIndexNode = this.deserializeConfig.deserializeMetadataIndexNode(this.reader.readData(metadataIndexEntry.getOffset(), endOffset), currentChildLevelIsDevice);
        MetadataIndexNodeType metadataIndexNodeType = metadataIndexNode.getNodeType();
        List<IMetadataIndexEntry> children = metadataIndexNode.getChildren();
        long curEntryEndOffset = metadataIndexNode.getEndOffset();
        for (int i = children.size() - 1; i >= 0; --i) {
            this.metadataIndexEntryStack.push(new MetadataIndexEntryInfo(children.get(i), metadataIndexNodeType, curEntryEndOffset));
            curEntryEndOffset = children.get(i).getOffset();
        }
    }

    private static class MetadataIndexEntryInfo {
        private final IMetadataIndexEntry metadataIndexEntry;
        private final MetadataIndexNodeType metadataIndexNodeType;
        private final long endOffset;

        public MetadataIndexEntryInfo(IMetadataIndexEntry metadataIndexEntry, MetadataIndexNodeType metadataIndexNodeType, long endOffset) {
            this.metadataIndexEntry = metadataIndexEntry;
            this.metadataIndexNodeType = metadataIndexNodeType;
            this.endOffset = endOffset;
        }

        public IMetadataIndexEntry getMetadataIndexEntry() {
            return this.metadataIndexEntry;
        }

        public MetadataIndexNodeType getMetadataIndexNodeType() {
            return this.metadataIndexNodeType;
        }

        public long getEndOffset() {
            return this.endOffset;
        }
    }
}

