/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.tsfile.read.common;

import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import shaded.org.apache.tsfile.enums.TSDataType;
import shaded.org.apache.tsfile.read.TimeValuePair;
import shaded.org.apache.tsfile.read.common.DescReadBatchData;
import shaded.org.apache.tsfile.read.common.DescReadWriteBatchData;
import shaded.org.apache.tsfile.read.common.IBatchDataIterator;
import shaded.org.apache.tsfile.read.reader.IPointReader;
import shaded.org.apache.tsfile.utils.Binary;
import shaded.org.apache.tsfile.utils.TsPrimitiveType;
import shaded.org.apache.tsfile.write.UnSupportedDataTypeException;

public class BatchData {
    protected static final int CAPACITY_THRESHOLD = 1000;
    protected int capacity = 16;
    protected TSDataType dataType;
    protected BatchDataType batchDataType = BatchDataType.ORDINARY;
    protected int readCurListIndex;
    protected int readCurArrayIndex;
    protected int writeCurListIndex;
    protected int writeCurArrayIndex;
    protected int count;
    protected List<long[]> timeRet;
    protected List<boolean[]> booleanRet;
    protected List<int[]> intRet;
    protected List<long[]> longRet;
    protected List<float[]> floatRet;
    protected List<double[]> doubleRet;
    protected List<Binary[]> binaryRet;
    protected List<TsPrimitiveType[][]> vectorRet;

    public BatchData() {
        this.dataType = null;
    }

    public BatchData(TSDataType type) {
        this.init(type);
    }

    public boolean isEmpty() {
        return this.count == 0;
    }

    public boolean hasCurrent() {
        if (this.readCurListIndex == this.writeCurListIndex) {
            return this.readCurArrayIndex < this.writeCurArrayIndex;
        }
        return this.readCurListIndex < this.writeCurListIndex && this.readCurArrayIndex < this.capacity;
    }

    public void next() {
        ++this.readCurArrayIndex;
        if (this.readCurArrayIndex == this.capacity) {
            this.readCurArrayIndex = 0;
            ++this.readCurListIndex;
        }
    }

    public long currentTime() {
        return this.timeRet.get(this.readCurListIndex)[this.readCurArrayIndex];
    }

    public Object currentValue() {
        switch (this.dataType) {
            case INT32: 
            case DATE: {
                return this.getInt();
            }
            case INT64: 
            case TIMESTAMP: {
                return this.getLong();
            }
            case FLOAT: {
                return Float.valueOf(this.getFloat());
            }
            case DOUBLE: {
                return this.getDouble();
            }
            case BOOLEAN: {
                return this.getBoolean();
            }
            case TEXT: 
            case BLOB: 
            case STRING: {
                return this.getBinary();
            }
            case VECTOR: {
                return this.getVector();
            }
        }
        return null;
    }

    public TsPrimitiveType currentTsPrimitiveType() {
        switch (this.dataType) {
            case INT32: 
            case DATE: {
                return new TsPrimitiveType.TsInt(this.getInt());
            }
            case INT64: 
            case TIMESTAMP: {
                return new TsPrimitiveType.TsLong(this.getLong());
            }
            case FLOAT: {
                return new TsPrimitiveType.TsFloat(this.getFloat());
            }
            case DOUBLE: {
                return new TsPrimitiveType.TsDouble(this.getDouble());
            }
            case BOOLEAN: {
                return new TsPrimitiveType.TsBoolean(this.getBoolean());
            }
            case TEXT: 
            case BLOB: 
            case STRING: {
                return new TsPrimitiveType.TsBinary(this.getBinary());
            }
            case VECTOR: {
                return new TsPrimitiveType.TsVector(this.getVector());
            }
        }
        return null;
    }

    public TSDataType getDataType() {
        return this.dataType;
    }

    public void setDataType(TSDataType dataType) {
        this.dataType = dataType;
    }

    public BatchDataType getBatchDataType() {
        return this.batchDataType;
    }

    public void init(TSDataType type) {
        this.dataType = type;
        this.readCurListIndex = 0;
        this.readCurArrayIndex = 0;
        this.writeCurListIndex = 0;
        this.writeCurArrayIndex = 0;
        this.timeRet = new ArrayList<long[]>();
        this.timeRet.add(new long[this.capacity]);
        this.count = 0;
        switch (this.dataType) {
            case BOOLEAN: {
                this.booleanRet = new ArrayList<boolean[]>();
                this.booleanRet.add(new boolean[this.capacity]);
                break;
            }
            case INT32: 
            case DATE: {
                this.intRet = new ArrayList<int[]>();
                this.intRet.add(new int[this.capacity]);
                break;
            }
            case INT64: 
            case TIMESTAMP: {
                this.longRet = new ArrayList<long[]>();
                this.longRet.add(new long[this.capacity]);
                break;
            }
            case FLOAT: {
                this.floatRet = new ArrayList<float[]>();
                this.floatRet.add(new float[this.capacity]);
                break;
            }
            case DOUBLE: {
                this.doubleRet = new ArrayList<double[]>();
                this.doubleRet.add(new double[this.capacity]);
                break;
            }
            case TEXT: 
            case BLOB: 
            case STRING: {
                this.binaryRet = new ArrayList<Binary[]>();
                this.binaryRet.add(new Binary[this.capacity]);
                break;
            }
            case VECTOR: {
                this.vectorRet = new ArrayList<TsPrimitiveType[][]>();
                this.vectorRet.add(new TsPrimitiveType[this.capacity][]);
                break;
            }
            default: {
                throw new UnSupportedDataTypeException(String.valueOf((Object)this.dataType));
            }
        }
    }

    public void putBoolean(long t, boolean v) {
        if (this.writeCurArrayIndex == this.capacity) {
            if (this.capacity >= 1000) {
                this.timeRet.add(new long[this.capacity]);
                this.booleanRet.add(new boolean[this.capacity]);
                ++this.writeCurListIndex;
                this.writeCurArrayIndex = 0;
            } else {
                int newCapacity = this.capacity << 1;
                long[] newTimeData = new long[newCapacity];
                boolean[] newValueData = new boolean[newCapacity];
                System.arraycopy(this.timeRet.get(0), 0, newTimeData, 0, this.capacity);
                System.arraycopy(this.booleanRet.get(0), 0, newValueData, 0, this.capacity);
                this.timeRet.set(0, newTimeData);
                this.booleanRet.set(0, newValueData);
                this.capacity = newCapacity;
            }
        }
        this.timeRet.get((int)this.writeCurListIndex)[this.writeCurArrayIndex] = t;
        this.booleanRet.get((int)this.writeCurListIndex)[this.writeCurArrayIndex] = v;
        ++this.writeCurArrayIndex;
        ++this.count;
    }

    public void putInt(long t, int v) {
        if (this.writeCurArrayIndex == this.capacity) {
            if (this.capacity >= 1000) {
                this.timeRet.add(new long[this.capacity]);
                this.intRet.add(new int[this.capacity]);
                ++this.writeCurListIndex;
                this.writeCurArrayIndex = 0;
            } else {
                int newCapacity = this.capacity << 1;
                long[] newTimeData = new long[newCapacity];
                int[] newValueData = new int[newCapacity];
                System.arraycopy(this.timeRet.get(0), 0, newTimeData, 0, this.capacity);
                System.arraycopy(this.intRet.get(0), 0, newValueData, 0, this.capacity);
                this.timeRet.set(0, newTimeData);
                this.intRet.set(0, newValueData);
                this.capacity = newCapacity;
            }
        }
        this.timeRet.get((int)this.writeCurListIndex)[this.writeCurArrayIndex] = t;
        this.intRet.get((int)this.writeCurListIndex)[this.writeCurArrayIndex] = v;
        ++this.writeCurArrayIndex;
        ++this.count;
    }

    public void putLong(long t, long v) {
        if (this.writeCurArrayIndex == this.capacity) {
            if (this.capacity >= 1000) {
                this.timeRet.add(new long[this.capacity]);
                this.longRet.add(new long[this.capacity]);
                ++this.writeCurListIndex;
                this.writeCurArrayIndex = 0;
            } else {
                int newCapacity = this.capacity << 1;
                long[] newTimeData = new long[newCapacity];
                long[] newValueData = new long[newCapacity];
                System.arraycopy(this.timeRet.get(0), 0, newTimeData, 0, this.capacity);
                System.arraycopy(this.longRet.get(0), 0, newValueData, 0, this.capacity);
                this.timeRet.set(0, newTimeData);
                this.longRet.set(0, newValueData);
                this.capacity = newCapacity;
            }
        }
        this.timeRet.get((int)this.writeCurListIndex)[this.writeCurArrayIndex] = t;
        this.longRet.get((int)this.writeCurListIndex)[this.writeCurArrayIndex] = v;
        ++this.writeCurArrayIndex;
        ++this.count;
    }

    public void putFloat(long t, float v) {
        if (this.writeCurArrayIndex == this.capacity) {
            if (this.capacity >= 1000) {
                this.timeRet.add(new long[this.capacity]);
                this.floatRet.add(new float[this.capacity]);
                ++this.writeCurListIndex;
                this.writeCurArrayIndex = 0;
            } else {
                int newCapacity = this.capacity << 1;
                long[] newTimeData = new long[newCapacity];
                float[] newValueData = new float[newCapacity];
                System.arraycopy(this.timeRet.get(0), 0, newTimeData, 0, this.capacity);
                System.arraycopy(this.floatRet.get(0), 0, newValueData, 0, this.capacity);
                this.timeRet.set(0, newTimeData);
                this.floatRet.set(0, newValueData);
                this.capacity = newCapacity;
            }
        }
        this.timeRet.get((int)this.writeCurListIndex)[this.writeCurArrayIndex] = t;
        this.floatRet.get((int)this.writeCurListIndex)[this.writeCurArrayIndex] = v;
        ++this.writeCurArrayIndex;
        ++this.count;
    }

    public void putDouble(long t, double v) {
        if (this.writeCurArrayIndex == this.capacity) {
            if (this.capacity >= 1000) {
                this.timeRet.add(new long[this.capacity]);
                this.doubleRet.add(new double[this.capacity]);
                ++this.writeCurListIndex;
                this.writeCurArrayIndex = 0;
            } else {
                int newCapacity = this.capacity << 1;
                long[] newTimeData = new long[newCapacity];
                double[] newValueData = new double[newCapacity];
                System.arraycopy(this.timeRet.get(0), 0, newTimeData, 0, this.capacity);
                System.arraycopy(this.doubleRet.get(0), 0, newValueData, 0, this.capacity);
                this.timeRet.set(0, newTimeData);
                this.doubleRet.set(0, newValueData);
                this.capacity = newCapacity;
            }
        }
        this.timeRet.get((int)this.writeCurListIndex)[this.writeCurArrayIndex] = t;
        this.doubleRet.get((int)this.writeCurListIndex)[this.writeCurArrayIndex] = v;
        ++this.writeCurArrayIndex;
        ++this.count;
    }

    public void putBinary(long t, Binary v) {
        if (this.writeCurArrayIndex == this.capacity) {
            if (this.capacity >= 1000) {
                this.timeRet.add(new long[this.capacity]);
                this.binaryRet.add(new Binary[this.capacity]);
                ++this.writeCurListIndex;
                this.writeCurArrayIndex = 0;
            } else {
                int newCapacity = this.capacity << 1;
                long[] newTimeData = new long[newCapacity];
                Binary[] newValueData = new Binary[newCapacity];
                System.arraycopy(this.timeRet.get(0), 0, newTimeData, 0, this.capacity);
                System.arraycopy(this.binaryRet.get(0), 0, newValueData, 0, this.capacity);
                this.timeRet.set(0, newTimeData);
                this.binaryRet.set(0, newValueData);
                this.capacity = newCapacity;
            }
        }
        this.timeRet.get((int)this.writeCurListIndex)[this.writeCurArrayIndex] = t;
        this.binaryRet.get((int)this.writeCurListIndex)[this.writeCurArrayIndex] = v;
        ++this.writeCurArrayIndex;
        ++this.count;
    }

    public void putVector(long t, TsPrimitiveType[] v) {
        if (this.writeCurArrayIndex == this.capacity) {
            if (this.capacity >= 1000) {
                this.timeRet.add(new long[this.capacity]);
                this.vectorRet.add(new TsPrimitiveType[this.capacity][]);
                ++this.writeCurListIndex;
                this.writeCurArrayIndex = 0;
            } else {
                int newCapacity = this.capacity << 1;
                long[] newTimeData = new long[newCapacity];
                TsPrimitiveType[][] newValueData = new TsPrimitiveType[newCapacity][];
                System.arraycopy(this.timeRet.get(0), 0, newTimeData, 0, this.capacity);
                System.arraycopy(this.vectorRet.get(0), 0, newValueData, 0, this.capacity);
                this.timeRet.set(0, newTimeData);
                this.vectorRet.set(0, newValueData);
                this.capacity = newCapacity;
            }
        }
        this.timeRet.get((int)this.writeCurListIndex)[this.writeCurArrayIndex] = t;
        this.vectorRet.get((int)this.writeCurListIndex)[this.writeCurArrayIndex] = v;
        ++this.writeCurArrayIndex;
        ++this.count;
    }

    public boolean getBoolean() {
        return this.booleanRet.get(this.readCurListIndex)[this.readCurArrayIndex];
    }

    public void setBoolean(boolean v) {
        this.booleanRet.get((int)this.readCurListIndex)[this.readCurArrayIndex] = v;
    }

    public int getInt() {
        return this.intRet.get(this.readCurListIndex)[this.readCurArrayIndex];
    }

    public void setInt(int v) {
        this.intRet.get((int)this.readCurListIndex)[this.readCurArrayIndex] = v;
    }

    public long getLong() {
        return this.longRet.get(this.readCurListIndex)[this.readCurArrayIndex];
    }

    public void setLong(long v) {
        this.longRet.get((int)this.readCurListIndex)[this.readCurArrayIndex] = v;
    }

    public float getFloat() {
        return this.floatRet.get(this.readCurListIndex)[this.readCurArrayIndex];
    }

    public void setFloat(float v) {
        this.floatRet.get((int)this.readCurListIndex)[this.readCurArrayIndex] = v;
    }

    public double getDouble() {
        return this.doubleRet.get(this.readCurListIndex)[this.readCurArrayIndex];
    }

    public void setDouble(double v) {
        this.doubleRet.get((int)this.readCurListIndex)[this.readCurArrayIndex] = v;
    }

    public Binary getBinary() {
        return this.binaryRet.get(this.readCurListIndex)[this.readCurArrayIndex];
    }

    public void setBinary(Binary v) {
        this.binaryRet.get((int)this.readCurListIndex)[this.readCurArrayIndex] = v;
    }

    public TsPrimitiveType[] getVector() {
        return this.vectorRet.get(this.readCurListIndex)[this.readCurArrayIndex];
    }

    public void setVector(TsPrimitiveType[] v) {
        this.vectorRet.get((int)this.readCurListIndex)[this.readCurArrayIndex] = v;
    }

    public void setTime(long v) {
        this.timeRet.get((int)this.readCurListIndex)[this.readCurArrayIndex] = v;
    }

    public void putAnObject(long t, Object v) {
        switch (this.dataType) {
            case BOOLEAN: {
                this.putBoolean(t, (Boolean)v);
                break;
            }
            case INT32: 
            case DATE: {
                this.putInt(t, (Integer)v);
                break;
            }
            case INT64: 
            case TIMESTAMP: {
                this.putLong(t, (Long)v);
                break;
            }
            case FLOAT: {
                this.putFloat(t, ((Float)v).floatValue());
                break;
            }
            case DOUBLE: {
                this.putDouble(t, (Double)v);
                break;
            }
            case TEXT: 
            case BLOB: 
            case STRING: {
                this.putBinary(t, (Binary)v);
                break;
            }
            case VECTOR: {
                this.putVector(t, (TsPrimitiveType[])v);
                break;
            }
            default: {
                throw new UnSupportedDataTypeException(String.valueOf((Object)this.dataType));
            }
        }
    }

    public int length() {
        return this.count;
    }

    public long getTimeByIndex(int idx) {
        return this.timeRet.get(idx / this.capacity)[idx % this.capacity];
    }

    public long getLongByIndex(int idx) {
        return this.longRet.get(idx / this.capacity)[idx % this.capacity];
    }

    public double getDoubleByIndex(int idx) {
        return this.doubleRet.get(idx / this.capacity)[idx % this.capacity];
    }

    public int getIntByIndex(int idx) {
        return this.intRet.get(idx / this.capacity)[idx % this.capacity];
    }

    public float getFloatByIndex(int idx) {
        return this.floatRet.get(idx / this.capacity)[idx % this.capacity];
    }

    public Binary getBinaryByIndex(int idx) {
        return this.binaryRet.get(idx / this.capacity)[idx % this.capacity];
    }

    public boolean getBooleanByIndex(int idx) {
        return this.booleanRet.get(idx / this.capacity)[idx % this.capacity];
    }

    public TsPrimitiveType[] getVectorByIndex(int idx) {
        return this.vectorRet.get(idx / this.capacity)[idx % this.capacity];
    }

    public TimeValuePair getLastPairBeforeOrEqualTimestamp(long queryTime) {
        TimeValuePair resultPair = new TimeValuePair(Long.MIN_VALUE, null);
        this.resetBatchData();
        while (this.hasCurrent() && this.currentTime() <= queryTime) {
            resultPair.setTimestamp(this.currentTime());
            resultPair.setValue(this.currentTsPrimitiveType());
            this.next();
        }
        return resultPair;
    }

    public Object getValueInTimestamp(long time) {
        while (this.hasCurrent()) {
            if (this.currentTime() < time) {
                this.next();
                continue;
            }
            if (this.currentTime() == time) {
                Object value = this.currentValue();
                this.next();
                return value;
            }
            return null;
        }
        return null;
    }

    public long getMaxTimestamp() {
        return this.getTimeByIndex(this.length() - 1);
    }

    public long getMinTimestamp() {
        return this.getTimeByIndex(0);
    }

    public BatchDataIterator getBatchDataIterator() {
        return new BatchDataIterator();
    }

    public IBatchDataIterator getBatchDataIterator(int subIndex) {
        return new VectorBatchDataIterator(subIndex);
    }

    public void serializeData(DataOutputStream outputStream) throws IOException {
        switch (this.dataType) {
            case BOOLEAN: {
                for (int i = 0; i < this.length(); ++i) {
                    outputStream.writeLong(this.getTimeByIndex(i));
                    outputStream.writeBoolean(this.getBooleanByIndex(i));
                }
                break;
            }
            case DOUBLE: {
                for (int i = 0; i < this.length(); ++i) {
                    outputStream.writeLong(this.getTimeByIndex(i));
                    outputStream.writeDouble(this.getDoubleByIndex(i));
                }
                break;
            }
            case FLOAT: {
                for (int i = 0; i < this.length(); ++i) {
                    outputStream.writeLong(this.getTimeByIndex(i));
                    outputStream.writeFloat(this.getFloatByIndex(i));
                }
                break;
            }
            case TEXT: 
            case BLOB: 
            case STRING: {
                for (int i = 0; i < this.length(); ++i) {
                    outputStream.writeLong(this.getTimeByIndex(i));
                    Binary binary = this.getBinaryByIndex(i);
                    outputStream.writeInt(binary.getLength());
                    outputStream.write(binary.getValues());
                }
                break;
            }
            case INT64: 
            case TIMESTAMP: {
                for (int i = 0; i < this.length(); ++i) {
                    outputStream.writeLong(this.getTimeByIndex(i));
                    outputStream.writeLong(this.getLongByIndex(i));
                }
                break;
            }
            case INT32: 
            case DATE: {
                for (int i = 0; i < this.length(); ++i) {
                    outputStream.writeLong(this.getTimeByIndex(i));
                    outputStream.writeInt(this.getIntByIndex(i));
                }
                break;
            }
            case VECTOR: {
                for (int i = 0; i < this.length(); ++i) {
                    outputStream.writeLong(this.getTimeByIndex(i));
                    TsPrimitiveType[] values = this.getVectorByIndex(i);
                    outputStream.writeInt(values.length);
                    block24: for (TsPrimitiveType value : values) {
                        if (value == null) {
                            outputStream.write(0);
                            continue;
                        }
                        outputStream.write(1);
                        outputStream.write(value.getDataType().serialize());
                        switch (value.getDataType()) {
                            case BOOLEAN: {
                                outputStream.writeBoolean(value.getBoolean());
                                continue block24;
                            }
                            case DOUBLE: {
                                outputStream.writeDouble(value.getDouble());
                                continue block24;
                            }
                            case FLOAT: {
                                outputStream.writeFloat(value.getFloat());
                                continue block24;
                            }
                            case TEXT: 
                            case BLOB: 
                            case STRING: {
                                Binary binary = value.getBinary();
                                outputStream.writeInt(binary.getLength());
                                outputStream.write(binary.getValues());
                                continue block24;
                            }
                            case INT64: 
                            case TIMESTAMP: {
                                outputStream.writeLong(value.getLong());
                                continue block24;
                            }
                            case INT32: 
                            case DATE: {
                                outputStream.writeInt(value.getInt());
                                continue block24;
                            }
                            default: {
                                throw new IllegalArgumentException("Unknown data type for BatchData:" + (Object)((Object)this.dataType));
                            }
                        }
                    }
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown data type for BatchData:" + (Object)((Object)this.dataType));
            }
        }
    }

    public void resetBatchData() {
        this.readCurArrayIndex = 0;
        this.readCurListIndex = 0;
    }

    public void resetBatchData(int readCurArrayIndex, int readCurListIndex) {
        this.readCurArrayIndex = readCurArrayIndex;
        this.readCurListIndex = readCurListIndex;
    }

    public int getReadCurListIndex() {
        return this.readCurListIndex;
    }

    public int getReadCurArrayIndex() {
        return this.readCurArrayIndex;
    }

    public BatchData flip() {
        return this;
    }

    public static enum BatchDataType {
        ORDINARY,
        DESC_READ,
        DESC_READ_WRITE;


        public static BatchData deserialize(byte type, TSDataType dataType) {
            switch (type) {
                case 0: {
                    return new BatchData(dataType);
                }
                case 1: {
                    return new DescReadBatchData(dataType);
                }
                case 2: {
                    return new DescReadWriteBatchData(dataType);
                }
            }
            throw new IllegalArgumentException("Invalid input: " + type);
        }
    }

    private class BatchDataIterator
    implements IPointReader,
    IBatchDataIterator {
        private BatchDataIterator() {
        }

        @Override
        public boolean hasNext() {
            return BatchData.this.hasCurrent();
        }

        @Override
        public boolean hasNext(long minBound, long maxBound) {
            return this.hasNext();
        }

        @Override
        public void next() {
            BatchData.this.next();
        }

        @Override
        public long currentTime() {
            return BatchData.this.currentTime();
        }

        @Override
        public Object currentValue() {
            return BatchData.this.currentValue();
        }

        @Override
        public void reset() {
            BatchData.this.resetBatchData();
        }

        @Override
        public int totalLength() {
            return BatchData.this.length();
        }

        @Override
        public boolean hasNextTimeValuePair() {
            return this.hasNext();
        }

        @Override
        public TimeValuePair nextTimeValuePair() {
            TimeValuePair timeValuePair = new TimeValuePair(this.currentTime(), BatchData.this.currentTsPrimitiveType());
            this.next();
            return timeValuePair;
        }

        @Override
        public TimeValuePair currentTimeValuePair() {
            return new TimeValuePair(this.currentTime(), BatchData.this.currentTsPrimitiveType());
        }

        @Override
        public long getUsedMemorySize() {
            return 0L;
        }

        @Override
        public void close() {
        }
    }

    private class VectorBatchDataIterator
    extends BatchDataIterator {
        private final int subIndex;

        private VectorBatchDataIterator(int subIndex) {
            this.subIndex = subIndex;
        }

        @Override
        public boolean hasNext() {
            while (BatchData.this.hasCurrent() && this.currentValue() == null) {
                super.next();
            }
            return BatchData.this.hasCurrent();
        }

        @Override
        public boolean hasNext(long minBound, long maxBound) {
            while (BatchData.this.hasCurrent() && this.currentValue() == null && super.currentTime() >= minBound && super.currentTime() < maxBound) {
                super.next();
            }
            return BatchData.this.hasCurrent();
        }

        @Override
        public Object currentValue() {
            TsPrimitiveType v = BatchData.this.getVector()[this.subIndex];
            return v == null ? null : v.getValue();
        }

        @Override
        public int totalLength() {
            int cnt = 0;
            int readCurArrayIndexSave = BatchData.this.readCurArrayIndex;
            int readCurListIndexSave = BatchData.this.readCurListIndex;
            while (this.hasNext()) {
                ++cnt;
                super.next();
            }
            BatchData.this.readCurArrayIndex = readCurArrayIndexSave;
            BatchData.this.readCurListIndex = readCurListIndexSave;
            return cnt;
        }
    }
}

