/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.tsfile.read.common;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import shaded.org.apache.tsfile.read.expression.IExpression;
import shaded.org.apache.tsfile.read.expression.impl.BinaryExpression;
import shaded.org.apache.tsfile.read.expression.impl.GlobalTimeExpression;
import shaded.org.apache.tsfile.read.filter.factory.TimeFilterApi;

public class TimeRange
implements Comparable<TimeRange> {
    private long min = 0L;
    private long max = 0L;
    private boolean leftClose = true;
    private boolean rightClose = true;

    public TimeRange(long min, long max) {
        this.set(min, max);
    }

    @Override
    public int compareTo(TimeRange r) {
        if (r == null) {
            throw new NullPointerException("The input cannot be null!");
        }
        if (this.min > r.min) {
            return 1;
        }
        if (this.min < r.min) {
            return -1;
        }
        if (this.max > r.max) {
            return 1;
        }
        if (this.max < r.max) {
            return -1;
        }
        return 0;
    }

    public void setMin(long min) {
        if (min < 0L || min > this.max) {
            throw new IllegalArgumentException("Invalid input!");
        }
        this.min = min;
    }

    public void setMax(long max) {
        if (max < 0L || max < this.min) {
            throw new IllegalArgumentException("Invalid input!");
        }
        this.max = max;
    }

    public boolean contains(TimeRange r) {
        return this.min <= r.min && this.max >= r.max;
    }

    public boolean contains(long min, long max) {
        if (this.leftClose && this.rightClose) {
            return this.min <= min && this.max >= max;
        }
        if (this.leftClose) {
            return this.min <= min && this.max > max;
        }
        if (this.rightClose) {
            return this.min < min && this.max >= max;
        }
        return this.min < min && this.max > max;
    }

    public boolean contains(long time) {
        if (this.leftClose && this.rightClose) {
            return time >= this.min && time <= this.max;
        }
        if (this.leftClose) {
            return time >= this.min && time < this.max;
        }
        if (this.rightClose) {
            return time > this.min && time <= this.max;
        }
        return time > this.min && time < this.max;
    }

    public void set(long min, long max) {
        if (min > max) {
            throw new IllegalArgumentException("min:" + min + " should not be larger than max: " + max);
        }
        this.min = min;
        this.max = max;
    }

    public long getMin() {
        return this.min;
    }

    public long getMax() {
        return this.max;
    }

    public boolean intersects(TimeRange r) {
        if (!(this.leftClose && r.rightClose || r.max >= this.min)) {
            return false;
        }
        if (!this.leftClose && !r.rightClose && r.max <= this.min) {
            return false;
        }
        if (this.leftClose && r.rightClose && r.max <= this.min - 2L) {
            return false;
        }
        if (!(this.rightClose && r.leftClose || r.min <= this.max)) {
            return false;
        }
        if (!this.rightClose && !r.leftClose && r.min >= this.max) {
            return false;
        }
        return !this.rightClose || !r.leftClose || r.min < this.max + 2L;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TimeRange that = (TimeRange)o;
        return this.min == that.min && this.max == that.max;
    }

    public int hashCode() {
        return Objects.hash(this.min, this.max);
    }

    public boolean overlaps(TimeRange rhs) {
        if (!(this.leftClose && rhs.rightClose || rhs.max > this.min)) {
            return false;
        }
        if (!this.leftClose && !rhs.rightClose && rhs.max <= this.min + 1L) {
            return false;
        }
        if (this.leftClose && rhs.rightClose && rhs.max < this.min) {
            return false;
        }
        if (!(this.rightClose && rhs.leftClose || rhs.min < this.max)) {
            return false;
        }
        if (!this.rightClose && !rhs.leftClose && rhs.min + 1L >= this.max) {
            return false;
        }
        return !this.rightClose || !rhs.leftClose || rhs.min <= this.max;
    }

    public String toString() {
        StringBuilder res = new StringBuilder();
        if (this.leftClose) {
            res.append("[ ");
        } else {
            res.append("( ");
        }
        res.append(this.min).append(" : ").append(this.max);
        if (this.rightClose) {
            res.append(" ]");
        } else {
            res.append(" )");
        }
        return res.toString();
    }

    public void setLeftClose(boolean leftClose) {
        this.leftClose = leftClose;
    }

    public void setRightClose(boolean rightClose) {
        this.rightClose = rightClose;
    }

    public boolean getLeftClose() {
        return this.leftClose;
    }

    public boolean getRightClose() {
        return this.rightClose;
    }

    public static List<TimeRange> sortAndMerge(List<TimeRange> unionCandidates) {
        Collections.sort(unionCandidates);
        ArrayList<TimeRange> unionResult = new ArrayList<TimeRange>();
        Iterator<TimeRange> iterator = unionCandidates.iterator();
        if (!iterator.hasNext()) {
            return unionResult;
        }
        TimeRange rangeCurr = iterator.next();
        while (iterator.hasNext()) {
            TimeRange rangeNext = iterator.next();
            if (rangeCurr.intersects(rangeNext)) {
                rangeCurr.merge(rangeNext);
                continue;
            }
            unionResult.add(rangeCurr);
            rangeCurr = rangeNext;
        }
        unionResult.add(rangeCurr);
        return unionResult;
    }

    public void merge(TimeRange rhs) {
        this.set(Math.min(this.getMin(), rhs.getMin()), Math.max(this.getMax(), rhs.getMax()));
    }

    public List<TimeRange> getRemains(List<TimeRange> timeRangesPrev) {
        ArrayList<TimeRange> remains = new ArrayList<TimeRange>();
        for (TimeRange prev : timeRangesPrev) {
            if (prev.min >= this.max + 2L) break;
            if (!this.intersects(prev)) continue;
            if (prev.contains(this)) {
                return remains;
            }
            if (this.contains(prev)) {
                if (prev.min > this.min && prev.max == this.max) {
                    this.setMax(prev.min);
                    this.setRightClose(false);
                    remains.add(this);
                    return remains;
                }
                if (prev.min == this.min) {
                    this.min = prev.max;
                    this.leftClose = false;
                    continue;
                }
                TimeRange r = new TimeRange(this.min, prev.min);
                r.setLeftClose(this.leftClose);
                r.setRightClose(false);
                remains.add(r);
                this.min = prev.max;
                this.leftClose = false;
                continue;
            }
            if (prev.min < this.min) {
                this.min = prev.max;
                this.leftClose = false;
                continue;
            }
            this.setMax(prev.min);
            this.setRightClose(false);
            remains.add(this);
            return remains;
        }
        remains.add(this);
        return remains;
    }

    public IExpression getExpression() {
        GlobalTimeExpression left = this.leftClose ? new GlobalTimeExpression(TimeFilterApi.gtEq(this.min)) : new GlobalTimeExpression(TimeFilterApi.gt(this.min));
        GlobalTimeExpression right = this.rightClose ? new GlobalTimeExpression(TimeFilterApi.ltEq(this.max)) : new GlobalTimeExpression(TimeFilterApi.lt(this.max));
        return BinaryExpression.and(left, right);
    }
}

