/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.tsfile.read.common.block;

import java.util.Arrays;
import shaded.org.apache.tsfile.block.column.Column;
import shaded.org.apache.tsfile.read.common.TimeRange;
import shaded.org.apache.tsfile.read.common.block.TsBlock;
import shaded.org.apache.tsfile.read.common.block.TsBlockBuilder;
import shaded.org.apache.tsfile.read.filter.basic.Filter;
import shaded.org.apache.tsfile.read.reader.series.PaginationController;

public class TsBlockUtil {
    private TsBlockUtil() {
    }

    public static TsBlock skipPointsOutOfTimeRange(TsBlock tsBlock, TimeRange targetTimeRange, boolean ascending) {
        int firstIndex = TsBlockUtil.getFirstConditionIndex(tsBlock, targetTimeRange, ascending);
        return tsBlock.subTsBlock(firstIndex);
    }

    public static int getFirstConditionIndex(TsBlock tsBlock, TimeRange targetTimeRange, boolean ascending) {
        Column timeColumn = tsBlock.getTimeColumn();
        long targetTime = ascending ? targetTimeRange.getMin() : targetTimeRange.getMax();
        int left = 0;
        int right = timeColumn.getPositionCount() - 1;
        while (left < right) {
            int mid = left + right >> 1;
            if (timeColumn.getLong(mid) < targetTime) {
                if (ascending) {
                    left = mid + 1;
                    continue;
                }
                right = mid;
                continue;
            }
            if (timeColumn.getLong(mid) > targetTime) {
                if (ascending) {
                    right = mid;
                    continue;
                }
                left = mid + 1;
                continue;
            }
            if (timeColumn.getLong(mid) != targetTime) continue;
            return mid;
        }
        return left;
    }

    public static TsBlock applyFilterAndLimitOffsetToTsBlock(TsBlock unFilteredBlock, TsBlockBuilder builder, Filter pushDownFilter, PaginationController paginationController) {
        boolean[] selection = new boolean[unFilteredBlock.getPositionCount()];
        Arrays.fill(selection, true);
        boolean[] keepCurrentRow = pushDownFilter.satisfyTsBlock(selection, unFilteredBlock);
        int readEndIndex = TsBlockUtil.buildTimeColumnWithPagination(unFilteredBlock, builder, keepCurrentRow, paginationController);
        for (int i = 0; i < builder.getValueColumnBuilders().length; ++i) {
            for (int rowIndex = 0; rowIndex < readEndIndex; ++rowIndex) {
                if (!keepCurrentRow[rowIndex]) continue;
                if (unFilteredBlock.getValueColumns()[i].isNull(rowIndex)) {
                    builder.getColumnBuilder(i).appendNull();
                    continue;
                }
                builder.getColumnBuilder(i).writeObject(unFilteredBlock.getValueColumns()[i].getObject(rowIndex));
            }
        }
        return builder.build();
    }

    private static int buildTimeColumnWithPagination(TsBlock unFilteredBlock, TsBlockBuilder builder, boolean[] keepCurrentRow, PaginationController paginationController) {
        int readEndIndex = unFilteredBlock.getPositionCount();
        for (int rowIndex = 0; rowIndex < readEndIndex; ++rowIndex) {
            if (!keepCurrentRow[rowIndex]) continue;
            if (paginationController.hasCurOffset()) {
                paginationController.consumeOffset();
                keepCurrentRow[rowIndex] = false;
                continue;
            }
            if (paginationController.hasCurLimit()) {
                builder.getTimeColumnBuilder().writeLong(unFilteredBlock.getTimeByIndex(rowIndex));
                builder.declarePosition();
                paginationController.consumeLimit();
                continue;
            }
            readEndIndex = rowIndex;
            break;
        }
        return readEndIndex;
    }
}

