/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.tsfile.read.common.block.column;

import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import shaded.org.apache.tsfile.block.column.Column;
import shaded.org.apache.tsfile.enums.TSDataType;

public interface ColumnEncoder {
    public Column readColumn(ByteBuffer var1, TSDataType var2, int var3);

    public void writeColumn(DataOutputStream var1, Column var2) throws IOException;

    public static void serializeNullIndicators(DataOutputStream output, Column column) throws IOException {
        boolean mayHaveNull = column.mayHaveNull();
        output.writeBoolean(mayHaveNull);
        if (!mayHaveNull) {
            return;
        }
        ColumnEncoder.serializeBooleanArray(output, column, Column::isNull);
    }

    public static boolean[] deserializeNullIndicators(ByteBuffer input, int positionCount) {
        boolean mayHaveNull;
        boolean bl = mayHaveNull = input.get() != 0;
        if (!mayHaveNull) {
            return null;
        }
        return ColumnEncoder.deserializeBooleanArray(input, positionCount);
    }

    public static void serializeBooleanArray(DataOutputStream output, Column column, ColumnToBooleanFunction toBooleanFunction) throws IOException {
        int positionCount = column.getPositionCount();
        byte[] packedIsNull = new byte[((positionCount & 0xFFFFFFF8) + 1) / 8];
        int currentByte = 0;
        int position = 0;
        while (position < (positionCount & 0xFFFFFFF8)) {
            int value = 0;
            value = (byte)(value | (toBooleanFunction.apply(column, position) ? 128 : 0));
            value = (byte)(value | (toBooleanFunction.apply(column, position + 1) ? 64 : 0));
            value = (byte)(value | (toBooleanFunction.apply(column, position + 2) ? 32 : 0));
            value = (byte)(value | (toBooleanFunction.apply(column, position + 3) ? 16 : 0));
            value = (byte)(value | (toBooleanFunction.apply(column, position + 4) ? 8 : 0));
            value = (byte)(value | (toBooleanFunction.apply(column, position + 5) ? 4 : 0));
            value = (byte)(value | (toBooleanFunction.apply(column, position + 6) ? 2 : 0));
            packedIsNull[currentByte] = value = (int)((byte)(value | (toBooleanFunction.apply(column, position + 7) ? 1 : 0)));
            position += 8;
            ++currentByte;
        }
        output.write(packedIsNull);
        if ((positionCount & 7) > 0) {
            int value = 0;
            int mask = 128;
            for (int position2 = positionCount & 0xFFFFFFF8; position2 < positionCount; ++position2) {
                value = (byte)(value | (toBooleanFunction.apply(column, position2) ? mask : 0));
                mask >>>= 1;
            }
            output.write(value);
        }
    }

    public static boolean[] deserializeBooleanArray(ByteBuffer input, int size) {
        byte[] packedBooleanArray = new byte[(size + 7) / 8];
        input.get(packedBooleanArray);
        boolean[] output = new boolean[size];
        int currentByte = 0;
        int position = 0;
        while (position < (size & 0xFFFFFFF8)) {
            byte value = packedBooleanArray[currentByte];
            output[position] = (value & 0x80) != 0;
            output[position + 1] = (value & 0x40) != 0;
            output[position + 2] = (value & 0x20) != 0;
            output[position + 3] = (value & 0x10) != 0;
            output[position + 4] = (value & 8) != 0;
            output[position + 5] = (value & 4) != 0;
            output[position + 6] = (value & 2) != 0;
            output[position + 7] = (value & 1) != 0;
            position += 8;
            ++currentByte;
        }
        if ((size & 7) > 0) {
            byte value = packedBooleanArray[packedBooleanArray.length - 1];
            int mask = 128;
            for (int position2 = size & 0xFFFFFFF8; position2 < size; ++position2) {
                output[position2] = (value & mask) != 0;
                mask >>>= 1;
            }
        }
        return output;
    }

    public static interface ColumnToBooleanFunction {
        public boolean apply(Column var1, int var2);
    }
}

