/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.tsfile.read.common.block.column;

import java.util.HashMap;
import java.util.Map;
import shaded.org.apache.tsfile.block.column.ColumnEncoding;
import shaded.org.apache.tsfile.read.common.block.column.BinaryArrayColumnEncoder;
import shaded.org.apache.tsfile.read.common.block.column.ByteArrayColumnEncoder;
import shaded.org.apache.tsfile.read.common.block.column.ColumnEncoder;
import shaded.org.apache.tsfile.read.common.block.column.DictionaryColumnEncoder;
import shaded.org.apache.tsfile.read.common.block.column.Int32ArrayColumnEncoder;
import shaded.org.apache.tsfile.read.common.block.column.Int64ArrayColumnEncoder;
import shaded.org.apache.tsfile.read.common.block.column.RunLengthColumnEncoder;

public class ColumnEncoderFactory {
    private static final Map<ColumnEncoding, ColumnEncoder> encodingToEncoder = new HashMap<ColumnEncoding, ColumnEncoder>();

    private ColumnEncoderFactory() {
    }

    public static ColumnEncoder get(ColumnEncoding columnEncoding) {
        ColumnEncoder res = encodingToEncoder.get((Object)columnEncoding);
        if (res == null) {
            throw new IllegalArgumentException("Unsupported column encoding: " + (Object)((Object)columnEncoding));
        }
        return res;
    }

    static {
        encodingToEncoder.put(ColumnEncoding.INT32_ARRAY, new Int32ArrayColumnEncoder());
        encodingToEncoder.put(ColumnEncoding.INT64_ARRAY, new Int64ArrayColumnEncoder());
        encodingToEncoder.put(ColumnEncoding.BYTE_ARRAY, new ByteArrayColumnEncoder());
        encodingToEncoder.put(ColumnEncoding.BINARY_ARRAY, new BinaryArrayColumnEncoder());
        encodingToEncoder.put(ColumnEncoding.RLE, new RunLengthColumnEncoder());
        encodingToEncoder.put(ColumnEncoding.DICTIONARY, new DictionaryColumnEncoder());
    }
}

