/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.tsfile.read.common.block.column;

import java.util.Arrays;
import java.util.Optional;
import shaded.org.apache.tsfile.block.column.Column;
import shaded.org.apache.tsfile.block.column.ColumnEncoding;
import shaded.org.apache.tsfile.enums.TSDataType;
import shaded.org.apache.tsfile.read.common.block.column.ColumnUtil;
import shaded.org.apache.tsfile.read.common.block.column.DictionaryColumn;
import shaded.org.apache.tsfile.read.common.block.column.DictionaryId;
import shaded.org.apache.tsfile.utils.RamUsageEstimator;
import shaded.org.apache.tsfile.utils.TsPrimitiveType;

public class DoubleColumn
implements Column {
    private static final int INSTANCE_SIZE = (int)RamUsageEstimator.shallowSizeOfInstance(DoubleColumn.class);
    public static final int SIZE_IN_BYTES_PER_POSITION = 9;
    private final int arrayOffset;
    private int positionCount;
    private boolean[] valueIsNull;
    private final double[] values;
    private final long retainedSizeInBytes;

    public DoubleColumn(int initialCapacity) {
        this(0, 0, null, new double[initialCapacity]);
    }

    public DoubleColumn(int positionCount, Optional<boolean[]> valueIsNull, double[] values) {
        this(0, positionCount, valueIsNull.orElse(null), values);
    }

    DoubleColumn(int arrayOffset, int positionCount, boolean[] valueIsNull, double[] values) {
        if (arrayOffset < 0) {
            throw new IllegalArgumentException("arrayOffset is negative");
        }
        this.arrayOffset = arrayOffset;
        if (positionCount < 0) {
            throw new IllegalArgumentException("positionCount is negative");
        }
        this.positionCount = positionCount;
        if (values.length - arrayOffset < positionCount) {
            throw new IllegalArgumentException("values length is less than positionCount");
        }
        this.values = values;
        if (valueIsNull != null && valueIsNull.length - arrayOffset < positionCount) {
            throw new IllegalArgumentException("isNull length is less than positionCount");
        }
        this.valueIsNull = valueIsNull;
        this.retainedSizeInBytes = (long)INSTANCE_SIZE + RamUsageEstimator.sizeOfBooleanArray(positionCount) + RamUsageEstimator.sizeOfDoubleArray(positionCount);
    }

    @Override
    public TSDataType getDataType() {
        return TSDataType.DOUBLE;
    }

    @Override
    public ColumnEncoding getEncoding() {
        return ColumnEncoding.INT64_ARRAY;
    }

    @Override
    public double getDouble(int position) {
        return this.values[position + this.arrayOffset];
    }

    @Override
    public double[] getDoubles() {
        return this.values;
    }

    @Override
    public Object getObject(int position) {
        return this.getDouble(position);
    }

    @Override
    public TsPrimitiveType getTsPrimitiveType(int position) {
        return new TsPrimitiveType.TsDouble(this.getDouble(position));
    }

    @Override
    public boolean mayHaveNull() {
        return this.valueIsNull != null;
    }

    @Override
    public boolean isNull(int position) {
        return this.valueIsNull != null && this.valueIsNull[position + this.arrayOffset];
    }

    @Override
    public boolean[] isNull() {
        if (this.valueIsNull == null) {
            boolean[] res = new boolean[this.positionCount];
            Arrays.fill(res, false);
            return res;
        }
        return this.valueIsNull;
    }

    @Override
    public int getPositionCount() {
        return this.positionCount;
    }

    @Override
    public long getRetainedSizeInBytes() {
        return this.retainedSizeInBytes;
    }

    @Override
    public long getSizeInBytes() {
        return (long)this.positionCount * 9L;
    }

    @Override
    public Column getRegion(int positionOffset, int length) {
        ColumnUtil.checkValidRegion(this.getPositionCount(), positionOffset, length);
        return new DoubleColumn(positionOffset + this.arrayOffset, length, this.valueIsNull, this.values);
    }

    @Override
    public Column getRegionCopy(int positionOffset, int length) {
        ColumnUtil.checkValidRegion(this.getPositionCount(), positionOffset, length);
        int from = positionOffset + this.arrayOffset;
        int to = from + length;
        boolean[] valueIsNullCopy = this.valueIsNull != null ? Arrays.copyOfRange(this.valueIsNull, from, to) : null;
        double[] valuesCopy = Arrays.copyOfRange(this.values, from, to);
        return new DoubleColumn(0, length, valueIsNullCopy, valuesCopy);
    }

    @Override
    public Column subColumn(int fromIndex) {
        if (fromIndex > this.positionCount) {
            throw new IllegalArgumentException("fromIndex is not valid");
        }
        return new DoubleColumn(this.arrayOffset + fromIndex, this.positionCount - fromIndex, this.valueIsNull, this.values);
    }

    @Override
    public Column subColumnCopy(int fromIndex) {
        if (fromIndex > this.positionCount) {
            throw new IllegalArgumentException("fromIndex is not valid");
        }
        int from = this.arrayOffset + fromIndex;
        boolean[] valueIsNullCopy = this.valueIsNull != null ? Arrays.copyOfRange(this.valueIsNull, from, this.positionCount) : null;
        double[] valuesCopy = Arrays.copyOfRange(this.values, from, this.positionCount);
        int length = this.positionCount - fromIndex;
        return new DoubleColumn(0, length, valueIsNullCopy, valuesCopy);
    }

    @Override
    public Column getPositions(int[] positions, int offset, int length) {
        ColumnUtil.checkArrayRange(positions, offset, length);
        return DictionaryColumn.createInternal(offset, length, this, positions, DictionaryId.randomDictionaryId());
    }

    @Override
    public Column copyPositions(int[] positions, int offset, int length) {
        ColumnUtil.checkArrayRange(positions, offset, length);
        boolean[] newValueIsNull = null;
        if (this.valueIsNull != null) {
            newValueIsNull = new boolean[length];
        }
        double[] newValues = new double[length];
        for (int i = 0; i < length; ++i) {
            int position = positions[offset + i];
            ColumnUtil.checkReadablePosition(this, position);
            if (newValueIsNull != null) {
                newValueIsNull[i] = this.valueIsNull[position + this.arrayOffset];
            }
            newValues[i] = this.values[position + this.arrayOffset];
        }
        return new DoubleColumn(0, length, newValueIsNull, newValues);
    }

    @Override
    public void reverse() {
        int j;
        int i = this.arrayOffset;
        for (j = this.arrayOffset + this.positionCount - 1; i < j; ++i, --j) {
            double valueTmp = this.values[i];
            this.values[i] = this.values[j];
            this.values[j] = valueTmp;
        }
        if (this.valueIsNull != null) {
            i = this.arrayOffset;
            for (j = this.arrayOffset + this.positionCount - 1; i < j; ++i, --j) {
                boolean isNullTmp = this.valueIsNull[i];
                this.valueIsNull[i] = this.valueIsNull[j];
                this.valueIsNull[j] = isNullTmp;
            }
        }
    }

    @Override
    public int getInstanceSize() {
        return INSTANCE_SIZE;
    }

    @Override
    public void setPositionCount(int count) {
        this.positionCount = count;
    }

    @Override
    public void setNull(int start, int end) {
        if (this.valueIsNull == null) {
            this.valueIsNull = new boolean[this.values.length];
        }
        Arrays.fill(this.valueIsNull, start, end, true);
    }
}

